			/* @(#) main.c */

/** File: main.c  - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

/* included files */

#include <pwd.h>
#include <time.h>
#include <utmp.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/stat.h>
#include "../include/ku.h"

/* variables */

char	msgs;
char	*strs;
char	dev[10];
char	*ctime();
char	*fromHost="localhost";

int	c;
int	m_digit=TRUE;
int	optind=0;
int	this_option_optind;
int	option_index;

static  struct  option  long_options[] =
{
        {"all", 0, 0, 'a'},
        {"beep", 0, 0, 'b'},
        {"group", 1, 0, 'g'},
        {"gid", 1, 0, 'G'},
        {"header", 0, 0, 'h'},
        {"help", 0, 0, 'H'},
        {"kill", 0, 0, 'K'},
        {"string", 1, 0, 's'},
        {"idle", 1, 0, 'i'},
        {"prompt", 0, 0, 'p'},
        {"message", 3, 0, 'm'},
        {"telnet", 0, 0, 't'},
        {"tty", 1, 0, 'T'},
        {"user", 1, 0, 'u'},
        {"xterm", 0, 0, 'x'},
        {"verbose", 0, 0, 'v'},
        {"version", 0, 0, 'V'},
        {0, 0, 0, 0}
};

int	main(int argc, char *argv[])
{
	struct	stat	stats;
	time_t	lastChange;

	/* just the program no options/arguments */
	if (argc==1)
	{
		/** can't decide if i really want 
		 ** a heading or not .. =\
		 */

		#ifdef HEADER 
			printf("%-2s",	"  ");
			printf("%-9s",	"USER");
			printf("%-9s",	"TERM");
			printf("%-12s",	"LOGIN TIME");
			printf("%7s",	"IDLE");
			printf("%10s\n","FROM");
		#endif

		while ((u=getutent())!=(struct utmp *)NULL)
		{
			/* filter out any process but a user's */
			switch (u->ut_type)
			{
				case USER_PROCESS:
				{
					/* some funky 0 length
					 * user who is logged in.
					 * i think it comes from
					 * dorking around with
					 * xterms and such.
					 */
					if (strlen(u->ut_user)<=0)
						continue;
					else
						break;
				}				
				case LOGIN_PROCESS: continue;
				case INIT_PROCESS:  continue;
				case DEAD_PROCESS:  continue;
				case BOOT_TIME:	    continue;
				case NEW_TIME:      continue;
				case OLD_TIME:      continue;
				default:	    continue;
			}

			/* add "/dev/" directory prefix
			 * and append basename
			 */
		
			strcpy(dev, "/dev/");
			strcat(dev, u->ut_line);

			if (stat(dev,&stats)==0)
			{
				msgs=(stats.st_mode & S_IWGRP) ? '+' : '-';
			}
			else
			{
				msgs='?';
			}

			lastChange=stats.st_atime;

			printf("%c ", msgs);
			printf("%-9.*s",(int) sizeof(u->ut_name),u->ut_name);
			printf("%-9.*s", (int) sizeof(u->ut_line),u->ut_line);
			printf("%-12.12s",ctime(&u->ut_time)+4);
			printf("%8s",idleTime(lastChange));

			/* checks for telnet type connection */

			if (strstr(u->ut_host, ":0.")!=NULL)
			{
				printf("     [xterm]");
			}
			else
			{
				if (u->ut_host[0])
				{
					printf("     [%-9.*s]",(int) sizeof(u->ut_host), u->ut_host);
				}
				else
				{
					printf("     [%-9.*s]", (int) strlen(fromHost), fromHost);
				}
			}
			printf("\n");
		}
		exit(0);
	}

	/* allows non root users
	 * to print out the help
	 * screen and the version 
	 * information but can not
	 * access any other options
	 */

        if ((strcmp(argv[1],"-H")==0)
        ||(strcasecmp(argv[1],"--help")==0)
        ||(strcasecmp(argv[1],"-help")==0))
        {
                usageMoron(argv);
                exit(0);
        }

        if ((strcmp(argv[1],"-V")==0)
        ||(strcasecmp(argv[1],"--version")==0)
        ||(strcasecmp(argv[1],"-version")==0))
        {
		printf("%s\n",VERSION);
                exit(0);
        }


	/* when i started recoding this program
	 * i moved this here so regular users
	 * could run ku with no options, and
	 * so people couldn't say it's useless
	 * if ur not root.  there! i showed everyone 
	 */

	/* checks for root access first */
	if ((geteuid()!=0)||(getuid()!=0))
	{
		printf("%s -- root access required\n",getlogin());
		exit(1);
	}

	while (TRUE)
	{
		this_option_optind=(optind ? optind : 1);

		c=getopt_long_only(argc,argv,"aKhvtpbxv:m:g:G:i:T:s:u:HV",long_options,&option_index);

		if (c == -1)
			break;

		switch (c)
		{
			case 'v': opt.opt_v=TRUE; break;
			case 'a': opt.opt_a=TRUE; break;
			case 'b': opt.opt_b=TRUE; break;
			case 'h': opt.opt_h=TRUE; break;
			case 'x': opt.opt_x=TRUE; break;
			case 'p': opt.opt_p=TRUE; break;
			case 't': opt.opt_t=TRUE; break;
			case 'g': opt.opt_g=TRUE; args.g_arg=optarg; break;
			case 'T': opt.opt_T=TRUE; args.T_arg=optarg; break;
			case 's': opt.opt_s=TRUE; args.s_arg=optarg; break;
			case 'u': opt.opt_u=TRUE; args.u_arg=optarg; break;
			case 'G':
			{
				opt.opt_G=TRUE;
				/*
				if (strcasecmp(optarg,"0")==0)
				{
					printf("it's embarrasing but ku segfaults when \'ku -G 0\' is issued.\ni'm working on it, all other gids seem to work\n");
					exit(1);
				}
				else
				{
					args.G_arg=atoi(optarg);
					break;
				}
				*/
				args.G_arg=atoi(optarg);
				break;
			}
			case 'i':
			{
				/* lets work with what was
				 * given on the command line
				 */

				/* if a time of 0
				 * was given
				 */
				if (strcmp(optarg,"0")==0)
				{
					printf("ku -- a time greater than 0 is required\n");
					exit(1);
				}

				/* set the variable */
				(int) args.i_arg=atoi(optarg);

				/* see if it wasn't a number */
				if (args.i_arg<=0)
				{
					printf("ku -- use a numeric time not \'%s\'\n",optarg);
					exit(1);
				}
				opt.opt_i=TRUE;
				break;
			}
			case 'K':
			{
				printf("kill message is: %s\n",DKILL);
				exit(0);
			}
			case 'm':
			{
				opt.opt_m=TRUE;
				if (optarg)
				{
					opt.opt_msg=TRUE;
					sprintf(args.tmp_arg,"%s ",optarg);
					while (optind < argc)
					{
						sprintf(args.str,"%s ",argv[optind++]);
						strcat(args.tmp_arg,args.str);
					}
					args.m_arg=args.tmp_arg;
					break;
				}
				else
				{
					opt.opt_msg=FALSE;
					args.m_arg=DKILL;
				}
				break;
			}
			case 'H': opt.opt_H=TRUE; usageMoron(argv); exit(0);
			case 'V': opt.opt_V=TRUE; printf("%s\n",VERSION);  exit(0);
			default:
				printf ("try %s --help\n", argv[0]);
				exit(0);
		}
	}

	if ((strlen(argv[1])<2)||(strncmp(argv[1],"-",1)!=0)||(strcmp(argv[1],"--")==0))
	{
		printf("try %s --help\n",argv[0]);
		exit(1);
	}

	/* brings it all together */
	switch (CheckSanity(opt))
	{
		case 0:
			ProveCommandLine(opt,args, argv);
			exit(0);
		case 1:
			printf("try %s --help\n",argv[0]);
			exit(1);
	}
	exit(0);
}
/* EOF */
