			/* @(#) prove.c */

/** File: prove.c  - Copyright (C) 1997 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

#include <grp.h>
#include <pwd.h>
#include <utmp.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "../include/ku.h"

char	dev[24];

int	proved,fgroup,fprove,fgid,crap;
time_t	lastStroke;

struct	group	*g;
struct	passwd	*pw;
struct	stat	s;

int	ProveCommandLine(struct CLopt opt, struct CLargs args, char *argv[])
{
	while ((u=getutent())!=(struct utmp *)NULL)
	{
		sprintf(dev, "/dev/%s", u->ut_line);

		/* this is you */
		if (strcmp(dev,ttyname(1))==0)
			continue; 

		/* not a user we want to deal with */
		if (Process_Type(u)!=0)
			continue;

		/* --help or --version were issued so we'll stop here */
		if ((opt.opt_V)||(opt.opt_H))
			break;

		/* --group */
		if (opt.opt_g)
		{
			if (getgrnam(args.g_arg)==NULL)
                       	{
                       	        printf("no such group: %s\n",args.g_arg);
                       	        exit(0);
                       	}
			
			/* lets get the password structure */
			pw=getpwnam(u->ut_user);

                       	/* get the group structure info */
                       	g=getgrgid(pw->pw_gid);

                       	if (strcmp(g->gr_name,args.g_arg)==0)
                       	        fgroup=TRUE;
			else
				fgroup=FALSE;
		}

		/* --gid */
		if (opt.opt_G)
		{
			/* lets just check for root */
			if (args.G_arg==0)
			{
				if (strcmp(u->ut_user,"root")!=0)
					continue;
				else
					fgid=TRUE;
			}
			
			//while (((pw=getpwent())!=(struct passwd *)NULL)&&(args.G_arg!=0))
			while (pw=getpwnam(u->ut_user))
			{
				/* can't find the GID */
				if (getgrgid(args.G_arg)==NULL)
				{
					printf("no such GID: %d\n",args.G_arg);
					exit(0);
				}

				/* put this here to save on 
				 * valuble resources, we
				 * check here to see if the
				 * user who is logged in
				 * matches the username we
				 * pulled out of the passwd
				 * file.  if it's not a match
				 * keep going.
				 */

				if (strcmp(u->ut_user, pw->pw_name)!=0)
					continue;

				/* found a matching GID */
				if (args.G_arg==pw->pw_gid)
				{
					fgid=TRUE;
					break;
				}
				continue;
			
			}
			
			if (!fgid)
				continue;
		}

		/* --idle */
		if (opt.opt_i)
		{
			stat(dev,&s);
			lastStroke=s.st_atime;

			if (ProveIdleTime(lastStroke, args)!=0)
				continue;
		}

		/* --telnet */
		if (opt.opt_t)
		{
			/* this is an XTerm */
			if (strstr(u->ut_host,":0.")!=NULL)
			{
				continue;
			}

			/* localhost login */
			else if (!u->ut_host[0])
			{
				continue;
			}
		}

		/* --tty */
		if (opt.opt_T)
		{
			/* not the right tty keep going */
			if (strcmp(u->ut_line,args.T_arg)!=0)
				continue;
		}

		/* --string */
		if (opt.opt_s)
		{
			/* didn't match up keep going */
			if ((strstr(u->ut_user,args.s_arg)==NULL) 
			&& (strstr(u->ut_line,args.s_arg)==NULL)
			&& (strstr(u->ut_host,args.s_arg)==NULL))
				continue;
		}

		/* --user */
		if (opt.opt_u)
		{
			/* not the user we want */
			if (strcmp(args.u_arg,u->ut_user)!=0)
				continue;
		}

		/* --xterm */
		if (opt.opt_x)
		{
			/* this is NOT an XTerm */
			if (strstr(u->ut_host,":0.")==NULL)
				continue;
		}

		/* --all */
		if (opt.opt_a)
		{
			TermUser(u,opt,args,dev);
			fprove=TRUE;
			continue;
		} 

		/* call the routine to termiate the user */
		TermUser(u,opt,args,dev);
		fprove=TRUE;
	}

	/* we didn't find any users matching
	 * the command line options, so we
	 * will back out now.
	 */

	if (!fprove)
	{
		printf("couldn't match any users against command line options\n");
		return(1);
	}
	return(0);
}

/* checks to make sure it's a valid login (real user) */
int	Process_Type(struct utmp *u)
{
	/* filter out anything but a real user */
	switch (u->ut_type)
	{
	        case USER_PROCESS:
	        {
	                if (strlen(u->ut_user)<=0)
				return(1);
	                else
				return(0);
	        }
	        case LOGIN_PROCESS: return(1);
	        case INIT_PROCESS:  return(1);
	        case DEAD_PROCESS:  return(1);
	        case BOOT_TIME:     return(1);
	        case NEW_TIME:      return(1);
	        case OLD_TIME:      return(1);
	        default:            return(1);
	}
}
/* EOF */
