			/* @(#) usage.c */

/** File: usage.c ku (killuser) - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

#include <stdio.h>

char	usageMoron(char *argv[])
{
	printf("\nusage: %s [-abhHKgGimpstTuxvV] [--help, --version]\n\n",argv[0]);
	printf(" -a | --all     kills all users execpt you\n");
	printf(" -b | --beep    beeps with each termination\n");
	printf(" -h | --header  adds a header when -v (--verbose) is used\n");
	printf(" -H | --help    shows this help screen\n");
	printf(" -K | --kill	displays default kill message\n");
	printf(" -g | --group   <group> kills any user in <group>\n");
	printf(" -G | --gid     <gid> kills any user in <gid>\n");
	printf(" -i | --idle    <minutes> kills any user idle <minutes> or greater\n");
	printf(" -p | --prompt  prompt for permission before a user is terminated\n");
	printf(" -m | --message [optional message] prints specifed message to users\r
                tty before termination\n");
	printf(" -s | --string  <string> matches <string> in login name or tty\n");
	printf(" -t | --telnet  kills any telnets\n");
	printf(" -T | --tty     <tty> kills user on <tty>\n");
	printf(" -u | --user    <user> matches any login with <user>\n");
	printf(" -v | --verbose will print information about each user terminated\n");
	printf(" -V | --version prints version information\n");
	
	printf("\n all --long options can be called as -long");
	printf("\n all options can be combined to allow for pinpoint targeting\n");
	printf(" ku run with no arguments will show all users logged in\n");
	printf("\n The following are some variables that can be used in\n the kill message:\n\n");
	
	printf("\t\t%%l  (for the users login name)\n");
        printf("\t\t%%r  (for the users real name)\n");
        printf("\t\t%%g  (for the group id)\n");
        printf("\t\t%%G  (for the group name)\n");
        printf("\t\t%%h  (for the home directory)\n");
        printf("\t\t%%H  (for the host)\n");
        printf("\t\t%%p  (for the pid)\n");
        printf("\t\t%%s  (for the shell)\n");
        printf("\t\t%%t  (for the tty)\n");
        printf("\t\t%%V  (for program name and version)\n\n");

	exit(0);
}
/* EOF */
