			/* @(#) verbose.c */

/** File: verbose.c  - Copyright (C) 1998 Nathan Benson
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **/

#include <utmp.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include "../include/ku.h"

int	hstr=TRUE;
char	*from="localhost";

int	PrintVerbose(struct utmp *u,
		 struct CLopt opt,
		 struct CLargs args,
		 char dev[24])
{
	FILE *fopen(),*usertty;
	usertty=fopen(dev,"w");

	if ((opt.opt_h)&&(opt.opt_v)&&(hstr))
        {
		printf("%-9s", "USER");
		printf("%-9s", "TERM");
		printf("%-9s", "PID");
		printf("%-12s", "LOGIN TIME");
		printf("%9s\n", "FROM");
		hstr=FALSE;
	}

        /* if --verbose (-v) was issued */
        if (opt.opt_v)
        {
		printf("%-9.*s",(int) sizeof(u->ut_user), u->ut_user);
		printf("%-9.*s",(int) sizeof(u->ut_line), u->ut_line);
		printf("%-9.*d",(int) sizeof(u->ut_pid), u->ut_pid);
		printf("%-12.12s",ctime(&u->ut_time)+4);

                /* checks for an xterm */
		if (strstr(u->ut_host, ":0.")!=NULL)
		{
			printf("     [xterm]");
		}
		else
		{
			/* tells where the user telneted from */
			if (u->ut_host[0])
			{
				printf("     [%-9.*s]",(int) sizeof(u->ut_host), u->ut_host);
                        }

                        /* it's a localhost log in */
			else
			{
				printf("     [%-9.*s]", (int) strlen(from), from);
			}
		}
		/* beeps at you */
		if (opt.opt_b)
		{
			printf("\a\n");
			return(0);
		}
		else
		{
			printf("\n");
			return(0);
		}
	}
	/* beeps at you */
	if (opt.opt_b)
	{
		printf("\a");
		return(0);
	}
	return(0);
}
/* EOF */
