% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_initialisations.R
\name{initialise_default_Unscaled}
\alias{initialise_default_Unscaled}
\title{Default parameters for the scaled version of ATN as in Binzer et al.
  2016, with updates from Gauzens et al. 2020}
\usage{
initialise_default_Unscaled(model, temperature = 20)
}
\arguments{
\item{model}{an object of class \emph{ATN (Rcpp_Unscaled)}.}

\item{temperature}{numeric, ambient temperature of the ecosystem in Celsius.}
}
\value{
An object of class \emph{ATN (Rcpp_Unscaled)} with default
  parameters as in Delmas et al. (2017).
}
\description{
Initialise the default parametrisation for the scaled version of
  the ATN model as in Binzer et al. (2016), with updates from Gauzens et al. 2020
}
\examples{
 library(ATNr)
 set.seed(123)
 masses <- runif(20, 10, 100) #body mass of species
 L <- create_Lmatrix(masses, 10, Ropt = 10)
 L[L > 0] <- 1
 mod <- create_model_Unscaled(20, 10, masses, L)
 mod <- initialise_default_Unscaled(mod)
}
\references{
Binzer, A., Guill, C., Rall, B. C. & Brose, U.
Interactive effects of warming, eutrophication and size structure: impacts on biodiversity and food-web structure.
Glob. Change Biol. 22, 220-227 (2016).
Gauzens, B., Rall, B.C., Mendonca, V. et al.
Biodiversity of intertidal food webs in response to warming across latitudes.
Nat. Clim. Chang. 10, 264-269 (2020). https://doi.org/10.1038/s41558-020-0698-z
}
