% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btm.R
\name{terms.BTM}
\alias{terms.BTM}
\title{Get highest token probabilities for each topic or get biterms used in the model}
\usage{
\method{terms}{BTM}(x, type = c("tokens", "biterms"), threshold = 0, top_n = 5, ...)
}
\arguments{
\item{x}{an object of class BTM as returned by \code{\link{BTM}}}

\item{type}{a character string, either 'tokens' or 'biterms'. Defaults to 'tokens'.}

\item{threshold}{threshold in 0-1 range. Only the terms which are more likely than the threshold are returned for each topic. Only used in case type = 'tokens'.}

\item{top_n}{integer indicating to return the top n tokens for each topic only. Only used in case type = 'tokens'.}

\item{...}{not used}
}
\value{
Depending if type is set to 'tokens' or 'biterms' the following is returned:
\itemize{
\item If \code{type='tokens'}: Get the probability of the token given the topic P(w|z). 
It returns a list of data.frames (one for each topic) where each data.frame contains columns token and probability ordered from high to low.
The list is the same length as the number of topics.
\item If \code{type='biterms'}: a list containing 2 elements: 
\itemize{
\item \code{n} which indicates the number of biterms used to train the model
\item \code{biterms} which is a data.frame with columns term1, term2 and topic, 
indicating for all biterms found in the data the topic to which the biterm is assigned to
}
Note that a biterm is unordered, in the output of \code{type='biterms'} term1 is always smaller than or equal to term2.
}
}
\description{
Get highest token probabilities for each topic or get biterms used in the model
}
\examples{
\dontshow{if(require(udpipe))\{}
library(udpipe)
data("brussels_reviews_anno", package = "udpipe")
x <- subset(brussels_reviews_anno, language == "nl")
x <- subset(x, xpos \%in\% c("NN", "NNP", "NNS"))
x <- x[, c("doc_id", "lemma")]
model  <- BTM(x, k = 5, iter = 5, trace = TRUE)
terms(model)
terms(model, top_n = 10)
terms(model, threshold = 0.01, top_n = +Inf)
bi <- terms(model, type = "biterms")
str(bi)
\dontshow{\} # End of main if statement running only if the required packages are installed}
}
\seealso{
\code{\link{BTM}}, \code{\link{predict.BTM}}, \code{\link{logLik.BTM}}
}
