% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interpolation.R
\name{CST_Interpolation}
\alias{CST_Interpolation}
\title{Regrid or interpolate gridded data to a point location.}
\usage{
CST_Interpolation(
  exp,
  points = NULL,
  method_remap = NULL,
  target_grid = NULL,
  lat_dim = "lat",
  lon_dim = "lon",
  region = NULL,
  method_point_interp = NULL,
  ncores = NULL
)
}
\arguments{
\item{exp}{s2dv object containing the experimental field on the
coarse scale for which the downscaling is aimed. The object must have, at least,
the dimensions latitude and longitude. The field data is expected to be already subset
for the desired region. Data can be in one or two integrated regions, e.g.,
crossing the Greenwich meridian. To get the correct results in the latter case,
the borders of the region should be specified in the parameter 'region'. See parameter
'region'.}

\item{points}{a list of two elements containing the point latitudes and longitudes
of the locations to downscale the model data. The list must contain the two elements
named as indicated in the parameters 'lat_dim' and 'lon_dim'. If the downscaling is
to a point location, only regular grids are allowed for exp and obs. Only needed if the
downscaling is to a point location.}

\item{method_remap}{a character vector indicating the regridding method to be passed
to CDORemap. Accepted methods are "con", "bil", "bic", "nn", "con2". If "nn" method is
to be used, CDO_1.9.8 or newer version is required. For method "con2",
CDO_2.2.2 or older version is required.}

\item{target_grid}{a character vector indicating the target grid to be passed to CDO.
It must be a grid recognised by CDO or a NetCDF file.}

\item{lat_dim}{a character vector indicating the latitude dimension name in the element
'exp' and/or 'points'. Default set to "lat".}

\item{lon_dim}{a character vector indicating the longitude dimension name in the element
'exp' and/or 'points'. Default set to "lon".}

\item{region}{a numeric vector indicating the borders of the interpolation region.
It consists of four elements in this order: lonmin, lonmax, latmin, latmax. lonmin refers
to the left border, while lonmax refers to the right border. latmin indicates the lower
border, whereas latmax indicates the upper border. If set to NULL (default), the function
takes the first and last elements of the latitudes and longitudes in exp.}

\item{method_point_interp}{a character vector indicating the interpolation method to
interpolate model gridded data into the point locations. Accepted methods are "nearest",
"bilinear", "9point", "invdist4nn", "NE", "NW", "SE", "SW".}

\item{ncores}{an integer indicating the number of cores to use in parallel computation.
The default value is NULL.}
}
\value{
An s2dv object containing the dowscaled field.
}
\description{
This function interpolates gridded model data from one grid to
another (regrid) or interpolates gridded model data to a set of point locations.
The gridded model data can be either global or regional. In the latter case, the
region is defined by the user. It does not have constrains of specific region or
variables to downscale.
}
\examples{
exp <- rnorm(500)
dim(exp) <- c(member = 5, lat = 4, lon = 5, sdate = 5, time  = 1)
lons <- 1:5
lats <- 1:4
exp <- CSTools::s2dv_cube(data = exp, coords = list(lat = lats, lon = lons)) 
if (Sys.which("cdo") != "") {
res <- CST_Interpolation(exp = exp, method_remap = 'conservative', target_grid = 'r1280x640')
}
}
\author{
J. Ramon, \email{jaume.ramon@bsc.es}
}
