library(testthat)
library(EFM)
library(MASS)

test_that("elliptical_errors returns expected structure for normal", {
  set.seed(123)
  n <- 100
  p <- 5
  mu <- rep(0, p)
  Sigma <- diag(p)
  data_normal <- MASS::mvrnorm(n, mu, Sigma)
  errors_normal <- elliptical_errors(data_normal, distribution = "normal")
  expect_is(errors_normal, "list")
  expect_true(is.numeric(errors_normal$mean_error))
  expect_true(is.numeric(errors_normal$normal_specific_error))
})

test_that("elliptical_errors returns expected structure for t", {
  set.seed(123)
  n <- 100
  p <- 5
  # 使用 stats::rt 生成 t 分布数据
  data_t <- matrix(stats::rt(n * p, df = 5), nrow = n, ncol = p)
  errors_t <- elliptical_errors(data_t, distribution = "t", df = 5)
  expect_is(errors_t, "list")
  expect_true(is.numeric(errors_t$mean_error))
  expect_true(is.numeric(errors_t$t_specific_error))
})