% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areaSouce.R
\name{areaSource}
\alias{areaSource}
\title{Distribution of emissions by area}
\source{
Example data from Defense Meteorological Satellite Program (DMSP)
}
\usage{
areaSource(s, r, grid = NA, name = "", as_frac = FALSE, verbose = TRUE)
}
\arguments{
\item{s}{input shape object}

\item{r}{input raster object}

\item{grid}{grid with the output format}

\item{name}{area name}

\item{as_frac}{return a fraction instead of the raster value}

\item{verbose}{display additional data}
}
\value{
a raster object containing the spatial distribution of emissions
}
\description{
Calculate the spatial distribution by a raster masked by shape/model grid information.
}
\examples{
shape  <- raster::shapefile(paste(system.file("extdata", package = "EmissV"),
                            "/BR.shp",sep=""),verbose = FALSE)
shape  <- shape[22,1] # subset for Sao Paulo - BR
raster <- raster::raster(paste(system.file("extdata", package = "EmissV"),
                         "/dmsp.tiff",sep=""))
grid   <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d02",sep=""))
SP     <- areaSource(shape,raster,grid,name = "SPMA")
\donttest{
raster::plot(SP,ylab="Lat",xlab="Lon",
             main ="Spatial Distribution by Lights for Sao Paulo - Brazil")
}
}
