% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_exposure}
\alias{plot_exposure}
\title{Plot Exposure to Mosquito Bites by Hour for Bednet Users}
\usage{
plot_exposure(data, cPalette = c("#000000", "#E69F00", "#56B4E9", "#009E73"))
}
\arguments{
\item{data}{A dataframe resulting from the \code{\link{calculate_Exp}} function, containing columns:
\itemize{
\item \code{hour} – hour of the day (0–23),
\item \code{Epo} – exposure outdoors,
\item \code{Epi} – exposure indoors (not under a net),
\item \code{Epn} – exposure indoors under a net,
\item \code{Epp} – exposure prevented by net use.
}}

\item{cPalette}{A character vector of color values (hex codes or color names) used to fill each exposure category.
Must be of length 4 and will be applied in the following order:
\code{Prevented}, \code{Indoor (under net)}, \code{Indoor (no net)}, \code{Outdoor}.
Defaults to \code{c("#000000", "#E69F00", "#56B4E9", "#009E73")}.}
}
\value{
A \code{ggplot2} stacked area chart object showing the distribution of exposure types across centered hours.
}
\description{
Creates a stacked area chart showing the hourly distribution of exposure to mosquito bites
among bednet users, broken down by exposure type: outdoors, indoors (no net), indoors (under net),
and prevented exposure due to bednet use. The hours are centered on midnight for better visualization.
}
\examples{
# generate fake data 
df <- gen_df_human(n_individuals = 100, hours = c(0:9,17:23))
df_bites <- gen_df_mosquito() 
# calculate mean hourly exposure to bites
exposure_results <- calculate_Exp(df, df_bites)
# plot
plot_exposure(exposure_results)

}
