#' Physical Measurements of 4177 Abalones, a Species of Sea Snail.
#'
#' %% ~~ A concise (1-5 lines) description of the dataset. ~~
#'
#' See the web page \url{https://archive.ics.uci.edu/ml/datasets/Abalone} for
#' more information about the data set.
#'
#' @name abalone
#' @docType data
#' @format A data frame with 4177 observations on the following 9 variables.
#' \describe{
#' \item{Diameter}{Diameter Perpendicular to length, continuous}
#' \item{Height}{Height with with meat in shell, continuous.}
#' \item{Length}{Longest shell measurement, continuous}
#' \item{Rings}{+1.5 gives the age in years, integer}
#' \item{Sex}{Sex of the abalone, \code{F} is female, \code{M} male, and \code{I} infant, categorical.}
#' \item{Weight_S}{Grams after being dried, continuous.}
#' \item{Weight_Sh}{Grams weight of meat, continuous.}
#' \item{Weight_V}{Grams gut weight (after bleeding), continuous.}
#' \item{Weight_W}{Grams whole abalone, continuous.} }
#' @source Dua, D. and Graff, C. (2019). UCI Machine Learning Repository
#' \url{https://archive.ics.uci.edu/ml/}. Irvine, CA: University of California,
#' School of Information and Computer Science.
#'
#' @keywords datasets
#' @examples
#'
#' data(abalone)
#' ## maybe str(abalone) ; plot(abalone) ...
#'
NULL
