% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{si_to_mai_age}
\alias{si_to_mai_age}
\title{Convert a Standard Site Index Into an MAI(age) Site Index}
\usage{
si_to_mai_age(si, mai_variable, age, ytable)
}
\arguments{
\item{si}{Standard site index to be converted, must correspond to the site
index nomenclature of the yield table to be used (param \code{ytable}, see
below).}

\item{mai_variable}{Character, name of the mai_variable to be used. Must be
one if the mai variables listed in the \code{fe_yield_table} object
provided with the parameter \code{ytable}.}

\item{age}{The stand age (years) for which the mai site index is to be
defined, typically 100 years.}

\item{ytable}{An object of class \code{fe_yield_table}}
}
\value{
The requested mai value corresponding to the given standard
site index at the given age
}
\description{
A useful way of site indexing is to give the site index of a stand in terms
of a mean annual increment (mai) at a given age, typically 100 years. This
function converts a standard site index into such an mai site index. See
\code{\link{si_to_mai_max}} for an alternative mai based site indexing
method.
}
\examples{
 age <- 100
 mai_var <- "mai_m3_ha_yr" # mai in volume over bark before harvest

 si_to_mai_age(2.3, mai_var, age, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_age(0.7, mai_var, age, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_age(2.3, mai_var, age, fe_ytable_beech_wiedemann_moderate_1931)
 si_to_mai_age(0.7, mai_var, age, fe_ytable_beech_wiedemann_moderate_1931)

 mai_var <- "red_mai_m3_ha_yr" # mai in vol. under bark minus harvest losses
 si_to_mai_age(2.3, mai_var, age, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_age(0.7, mai_var, age, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_age(2.3, mai_var, age, fe_ytable_beech_wiedemann_moderate_1931)
 si_to_mai_age(0.7, mai_var, age, fe_ytable_beech_wiedemann_moderate_1931)

}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
