% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalLimits.R
\name{IntervalLimits}
\alias{IntervalLimits}
\title{Construct feasibility interval requirements}
\usage{
IntervalLimits(
  ...,
  protectionPercent = 0,
  protectionLimit = 0,
  loProtectionPercent = protectionPercent,
  loProtectionLimit = protectionLimit,
  rangePercent = 0,
  rangeMin = 0,
  primary,
  num,
  freq,
  freqVar,
  dominanceVar = NULL,
  intervalVar = NULL
)
}
\arguments{
\item{...}{Unused parameters}

\item{protectionPercent}{Required distance in percent between the true cell value and the upper
bound of the feasibility interval. If \code{loProtectionPercent} is not set,
the same percentage distance is also required to the lower bound.}

\item{protectionLimit}{Required absolute distance between the true cell value and the upper
bound of the feasibility interval. If \code{loProtectionLimit} is not set,
the same absolute distance is also required to the lower bound.}

\item{loProtectionPercent}{Required distance in percent between the true cell value and the lower
bound of the feasibility interval. Is by default set to \code{protectionPercent},
i.e. symmetrical requirements.}

\item{loProtectionLimit}{Required absolute distance between the true cell value and the lower
bound of the feasibility interval. Is by default set to \code{protectionLimit},
i.e. symmetrical requirements.}

\item{rangePercent}{Minimum required width of the feasibility interval expressed as a
percentage of the true cell value.}

\item{rangeMin}{Minimum required width of the feasibility interval expressed as an
absolute value.}

\item{primary}{The \code{primary} vector generated by parent function}

\item{num}{The \code{num} data frame generated by parent function}

\item{freq}{The \code{freq} vector generated by parent function}

\item{freqVar}{As input to e.g. \code{\link[=SuppressSmallCounts]{SuppressSmallCounts()}}}

\item{dominanceVar}{As input to e.g. \code{\link[=SuppressDominantCells]{SuppressDominantCells()}}}

\item{intervalVar}{Numerical variable(s) used for interval calculations.
If \code{NULL}, the variable names may be inferred from the \code{num} data frame
as a consequence of interval requirements created by the primary
function(s). If no variables can be inferred this way,
\code{dominanceVar}, first \code{numVar} or \code{freqVar} will be used.}
}
\value{
A matrix with column names constructed from the type of
requirement and the associated variable name.
}
\description{
Creates one or more sets of requirements for feasibility intervals of cell
values in protected tables. These can include lower bound requirements
("lomax_\emph{"), upper bound requirements ("upmin_}"), and/or minimum width
requirements ("rlim_*"). The requirements may be specified as relative
percentages or as absolute distances, and can be set symmetrically around
the true cell value or separately for lower and upper bounds.
}
\note{
Interval requirements can also be generated by the primary suppression
functions when \code{protectionIntervals = TRUE} is specified (see examples
below). More details are given in the description of \code{protectionIntervals}
in the \code{\link[=MagnitudeRule]{MagnitudeRule()}} and \code{\link[=PrimaryDefault]{PrimaryDefault()}} functions.
}
\examples{
dat <- SSBtoolsData("magnitude1")
dat["num2"] <- 1:nrow(dat)

SuppressDominantCells(data = dat, 
    numVar = "value", 
    formula = ~sector2 * geo + sector4 * eu, 
    contributorVar = "company", 
    k = c(80, 99), 
    rangePercent = 10, rangeMin = 1,
    protectionPercent = 3, 
    protectionLimit = 5, loProtectionLimit = 4)

SuppressDominantCells(data = dat, 
    dominanceVar = "value",
    numVar = "num2", 
    formula = ~sector2 * geo + sector4 * eu, 
    contributorVar = "company", 
    pPercent = 10,
    intervalVar = c("value","freq", "num2"), 
    rangePercent = c(10, 10, 30), rangeMin = c(1, 0.2222, 2.222))
    

    
## Below are two alternative ways of calculating interval requirements. 
## In these cases, the requirements are generated by the primary suppression 
## functions when the parameter `protectionIntervals = TRUE` is specified.


# See ?MagnitudeRule
SuppressDominantCells(data = dat, 
                      dominanceVar = "value",
                      formula = ~sector2 * geo + sector4 * eu, 
                      contributorVar = "company", 
                      pPercent = 10,
                      protectionIntervals = TRUE)

# See ?PrimaryDefault
SuppressSmallCounts(data = dat, 
                    formula = ~sector2 * geo + sector4 * eu, 
                    maxN = 3,
                    protectionIntervals = TRUE)     
                    
                    
                    
## Combining IntervalLimits arguments 
## with protectionIntervals = TRUE also works

SuppressSmallCounts(data = dat, 
                    formula = ~sector2 * geo + sector4 * eu, 
                    maxN = 3,
                    protectionIntervals = TRUE,
                    protectionPercent = 50)

}
