% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Data.Curve-class.R, R/RLum.Data.Spectrum-class.R
\name{bin_RLum.Data}
\alias{bin_RLum.Data}
\alias{bin_RLum.Data,RLum.Data.Curve-method}
\alias{bin_RLum.Data,RLum.Data.Spectrum-method}
\title{Channel binning for RLum.Data-class objects}
\usage{
bin_RLum.Data(object, ...)

\S4method{bin_RLum.Data}{RLum.Data.Curve}(object, bin_size = 2)

\S4method{bin_RLum.Data}{RLum.Data.Spectrum}(object, bin_size.col = 1, bin_size.row = 1)
}
\arguments{
\item{object}{\linkS4class{RLum.Data} (\strong{required}):
S4 object of class \code{RLum.Data}}

\item{...}{further arguments passed to the specific class method}

\item{bin_size}{\link{integer} (\emph{with default}):
number of channels used for each bin, e.g. \code{bin_size = 2} means that
two channels are binned.}

\item{bin_size.col}{\link{integer} (\emph{with default}):
number of channels used for each bin, e.g. \code{bin_size.col = 2} means that
two channels are binned. Note: The function does not check the input, very large values
mean a full column binning (a single sum)}

\item{bin_size.row}{\link{integer} (\emph{with default}):
number of channels used for each bin, e.g. \code{bin_size.row = 2} means that
two channels are binned. Note: The function does not check the input, very large values
mean a full row binning (a single sum)}
}
\value{
An object of the same type as the input provided after binning is applied.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum.Data} objects. Depending on the input object, the corresponding
function will be selected.
}
\section{Functions}{
\itemize{
\item \code{bin_RLum.Data(RLum.Data.Curve)}: Allows binning of RLum.Data.Curve data.

\item \code{bin_RLum.Data(RLum.Data.Spectrum)}: Allows binning of RLum.Data.Spectrum data. Count values and values on the
x-axis are summed up; for wavelength/energy values, the mean is calculated.

}}
\note{
Currently only \code{RLum.Data} objects of class \linkS4class{RLum.Data.Curve}
and \linkS4class{RLum.Data.Spectrum} are supported.
}
\section{Function version}{
 0.2.0
}

\examples{

## load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

## create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

## plot data without and with 2 and 4 channel binning
plot_RLum(curve)
plot_RLum(bin_RLum.Data(curve, bin_size = 2))
plot_RLum(bin_RLum.Data(curve, bin_size = 4))

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. bin_RLum.Data(): Channel binning for RLum.Data-class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
