% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mode.R
\name{estimate_mode}
\alias{estimate_mode}
\title{Estimate Mode using Density function to find Mode of continuous data}
\usage{
estimate_mode(x)
}
\arguments{
\item{x}{A numeric vector. Missing values (\code{NA}) are removed.}
}
\value{
A single numeric value representing the estimated mode.
}
\description{
Estimates the mode of a numeric vector by identifying the value corresponding
to the peak of its estimated probability density function.
}
\examples{
# Estimate the mode of continuous random data
set.seed(123)
x <- rnorm(1000, mean=5, sd=2)
estimate_mode(x)

# Estimate the mode of miles-per-gallon (mpg) in the mtcars dataset
data("mtcars")
estimate_mode(mtcars$mpg)

}
