% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JLL.R
\name{JLL}
\alias{JLL}
\title{Estimates the P-dynamics from JLL-based models}
\usage{
JLL(NonOrthoFactors, N, JLLinputs, CheckInputs = FALSE)
}
\arguments{
\item{NonOrthoFactors}{numeric matrix (\code{K x Td}). Time series of risk factors before orthogonalization.}

\item{N}{positive integer. Number of country-specific spanned factors.}

\item{JLLinputs}{list. Necessary inputs to estimate JLL models:
\enumerate{
  \item \code{Economies}: character vector. Set of \code{C} economies in the system.
  \item \code{DomUnit}: character. Name of the dominant economy, or "None" if not assigned (for "JLL No DomUnit" model).
  \item \code{WishSigmas}: logical. TRUE to estimate variance-covariance matrices and Cholesky factorizations; FALSE otherwise.
  \item \code{SigmaNonOrtho}: NULL or F x F matrix from non-orthogonalized dynamics.
  \item \code{JLLModelType}: character. Permissible choices: "JLL original", "JLL joint Sigma", "JLL No DomUnit".
}}

\item{CheckInputs}{logical. Whether to perform a prior consistency check on the inputs provided in \code{JLLinputs}. Default is FALSE.}
}
\value{
List of model parameters from both the orthogonalized and non-orthogonalized versions of the JLL-based models
}
\description{
Estimates the P-dynamics from JLL-based models
}
\section{General Notation}{

\itemize{
  \item \code{Td}: model time series dimension
  \item \code{C} number of countries in the system.
  \item \code{K}: total number of risk factors
}
}

\examples{
\donttest{
data(RiskFacFull)
RF_TS <- RiskFacFull
N <- 3
JLLinputs <- list(
  Economies = c("China", "Brazil", "Mexico", "Uruguay"), DomUnit = "China",
  WishSigmas = TRUE, SigmaNonOrtho = NULL, JLLModelType = "JLL original"
)
JLLPara <- JLL(RF_TS, N, JLLinputs)
}
}
\references{
Jotiskhatira, P. ; Le, A. and Lundblad, C. (2015). "Why do interest rates in different currencies co-move?" (Journal of Financial Economics)
}
