% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_init.R
\name{theta_init}
\alias{theta_init}
\title{Initialize the variables for the Gibbs sampler chain}
\usage{
theta_init(prior, params)
}
\arguments{
\item{prior}{A list containing the prior configuration to draw initialization from. This list should match the structure produced by the \code{prior_init} function, including hyperparameters for FE, RE, Latent, and cluster assignment priors.}

\item{params}{A list containing the problem's dimensional parameters and indices (e.g., number of observations, number of covariates). This list should match the structure of the output from \code{process_Data_outcome}.}
}
\value{
A list (\code{theta}) containing the sampled initialization values for the Gibbs sampler. Key elements include:
\describe{
  \item{\code{sig2}:}{ Initial residual variance.}
  \item{\code{betaFE}:}{ Initial fixed effects coefficients.}
  \item{\code{SigRE}:}{ Initial random effects covariance matrix.}
  \item{\code{SigLat}:}{ Initial latent effects covariance matrix.}
  \item{\code{gammaLat}:}{ Initial latent effects coefficients, organized by cluster.}
  \item{\code{ClusCont}:}{ List containing initial continuous cluster parameters (\code{mu} and \code{Sigma}).}
  \item{\code{ClusCat}:}{ List containing initial categorical cluster parameters (\code{pvecClus}).}
}
}
\description{
This function generates initial values (\code{theta}) for all parameters in the Profile GLMM Gibbs sampler by drawing from the specified prior distributions. These initial values are crucial for starting the MCMC chain in \code{profileGLMM_Gibbs}. The initialization includes parameters for fixed effects, random effects variance, latent effects, and the profile cluster parameters (centroids, covariances, and categorical probability vectors).
}
\examples{
# Load dataProfile, the result of profileGLMM_preProcess()
data("examp")
dataProfile = examp$dataProfile
theta = theta_init(dataProfile$prior,dataProfile$params)
}
