% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferenceFunk.R
\name{llfunk_iLinear_Gaussian}
\alias{llfunk_iLinear_Gaussian}
\title{Log-likelihood function: independent-linear Gaussian}
\usage{
llfunk_iLinear_Gaussian(Ysim, Yobs, Yu, gamma)
}
\arguments{
\item{Ysim}{data frame, model-simulated values.}

\item{Yobs}{data frame, corresponding observed values, same dimensions as Ysim. NAs are skipped.}

\item{Yu}{data frame, measurement uncertainties (standard deviations), same dimensions as Ysim and Yobs.}

\item{gamma}{numeric vector, structural error parameters, organized as:
gamma=c((g1,g2) for the 1st component of Ysim,(g1,g2) for the 2nd component of Ysim, etc.)
=> length(gamma) = 2*(number of columns in Ysim).}
}
\value{
A numeric value equal to the log-likelihood.
}
\description{
Computes the log-likelihood from model-simulated values based on a Gaussian independent
error model with linearly-varying standard deviation:
\itemize{
    \item Yobs = Ysim + delta + epsilon
    \item Measurement errors: delta~ N(0,sdev=Yu)
    \item Structural errors: epsilon~ N(0,sdev=g1+g2*|Ysim|)
}
If Yobs/Ysim are multi-variate, this error model is applied independently to each component.
}
\examples{
Yobs=SauzeGaugings['Q']
Yu=SauzeGaugings['uQ']
Ysim=100*(SauzeGaugings['H']+0.5)^1.6
llfunk_iLinear_Gaussian(Ysim,Yobs,Yu,gamma=c(1,0.1))
}
