% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escalation_rule.R
\name{EscalationRule}
\alias{EscalationRule}
\title{EscalationRule Class}
\description{
This class represents an escalation rule that generates a next escalation.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{policy}}{The RLlib policy that is a Python object.}

\item{\code{dir}}{Directory path of the escalation rule (policy).}

\item{\code{dirpath}}{Full path to the directory of the escalation rule.}

\item{\code{created_at}}{Created time of this object.}

\item{\code{info}}{Information when learning the escalation rule.}

\item{\code{input}}{Inputs for learning the escalation rule.}

\item{\code{log}}{The log of scores during the learning of the escalation rule.}

\item{\code{checkpoints}}{The integer vector of iteration counts for checkpoints.}

\item{\code{checkpoints_paths}}{The paths to the directories where each checkpoint is stored.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EscalationRule-new}{\code{EscalationRule$new()}}
\item \href{#method-EscalationRule-opt_action}{\code{EscalationRule$opt_action()}}
\item \href{#method-EscalationRule-resume_learning}{\code{EscalationRule$resume_learning()}}
\item \href{#method-EscalationRule-set_info}{\code{EscalationRule$set_info()}}
\item \href{#method-EscalationRule-print}{\code{EscalationRule$print()}}
\item \href{#method-EscalationRule-clone}{\code{EscalationRule$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-new"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-new}{}}}
\subsection{Method \code{new()}}{
Create a new EscalationRule object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$new(dir = "latest", base_dir = "escalation_rules")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{A character value. A directory name or path where an
escalation rule is outputted. By default, the latest escalation
rule is searched in 'base_dir'.}

\item{\code{base_dir}}{A character value. A directory path that is used as the
parent directory if the 'dir' argument is a directory name and is
not used otherwise.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-opt_action"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-opt_action}{}}}
\subsection{Method \code{opt_action()}}{
Compute optimal action probabilities using the obtained escalation rule
for data of N and DLT.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$opt_action(current_dose, data_Ns, data_DLTs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current_dose}}{An integer value. This is the current dose index,
which is within \code{1:J}.}

\item{\code{data_Ns}}{A numeric vector. The cumulative number of patients
assigned to each dose in your clinical trial.}

\item{\code{data_DLTs}}{A numeric vector. The cumulative number of DLTs
corresponding to each dose for the 'data_Ns' argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character that represents the optimal action. One of the followings:
down, stay, up, MTD_1, ..., MTD_J, no_MTD
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-resume_learning"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-resume_learning}{}}}
\subsection{Method \code{resume_learning()}}{
Resume learning the escalation rule. This function updates the original
EscalationRule object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$resume_learning(iter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iter}}{A number of additional iterations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated \link{EscalationRule} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-set_info"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-set_info}{}}}
\subsection{Method \code{set_info()}}{
Set information when learning the escalation rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$set_info(info, input, log, checkpoints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{info}}{Information when learning the escalation rule.}

\item{\code{input}}{Inputs for learning the escalation rule.}

\item{\code{log}}{The log of scores during the learning of the escalation rule.}

\item{\code{checkpoints}}{The paths to the directories where each checkpoint is stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-print"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-print}{}}}
\subsection{Method \code{print()}}{
Print function for EscalationRule object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EscalationRule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EscalationRule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EscalationRule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
