% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_table.R
\name{base_table}
\alias{base_table}
\title{Create a Summary Table with Grouping and Custom Formatting}
\usage{
base_table(
  data1,
  by_group = FALSE,
  var_group,
  quali = NULL,
  quanti = NULL,
  digits = list(mean_sd = 1, median_q1_q3_min_max = 1, pct = 1)
)
}
\arguments{
\item{data1}{A data frame containing the data to summarize.}

\item{by_group}{A boolean (default is FALSE) to analyse by group.}

\item{var_group}{A string or NULL, the variable to group by (optional).
If NULL, no grouping will be applied.}

\item{quali}{A character vector, the names of categorical variables to
treat as categorical in the summary table.}

\item{quanti}{A character vector, the names of continuous variables to
treat as continuous in the summary table.}

\item{digits}{A list, the number of decimal places to round categorical and
continuous variable. Default is list(mean_sd = 1,
median_q1_q3_min_max = 1, pct = 1).}
}
\value{
A \code{gtsummary} table summarizing the specified variables,
grouped by \code{var_group} if provided, with customizable statistics
and rounding options.
}
\description{
This function generates a summary table from a data frame with specified
grouping and variable types. It uses the \code{gtsummary} package to create
descriptive statistics for categorical and continuous variables, with
options for customizing the rounding and labels.
}
\examples{
# Example usage with the iris dataset
base_table(iris, var_group = "Species")

}
