% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.aplms.R
\name{summary.aplms}
\alias{summary.aplms}
\title{Print method for "aplms" class}
\usage{
\method{summary}{aplms}(object, ...)
}
\arguments{
\item{object}{an object with the result of fitting additive partial linear models with symmetric errors.}

\item{...}{Other arguments passed to or from other methods.}
}
\value{
Prints the main results of the fitted APLMS model.
}
\description{
Print method for "aplms" class
}
\examples{
data(temperature)
temperature.df = data.frame(temperature,time=1:length(temperature))
model<-aplms::aplms(temperature ~ 1,
                   npc=c("time"), basis=c("cr"),Knot=c(60),
                   data=temperature.df,family=Powerexp(k=0.3),p=1,
                   control = list(tol = 0.001,
                                  algorithm1 = c("P-GAM"),
                                  algorithm2 = c("BFGS"),
                                  Maxiter1 = 20,
                                  Maxiter2 = 25),
                   lam=c(10))
summary(model)
}
