% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-resource.R
\name{api_resource}
\alias{api_resource}
\title{Azure API Resource}
\description{
An R6 class that wraps an \code{api_client} and adds an additional path segment
(like "beta" or "v1.0") to all requests. This is useful for APIs that version
their endpoints or have different API surfaces under different paths.
}
\details{
The \code{api_resource} class creates a modified base request by appending an
endpoint path to the client's base request. All subsequent API calls through
this resource will automatically include this path prefix.
}
\examples{
\dontrun{
# Create a client
client <- api_client$new(
  host_url = "https://graph.microsoft.com"
)

# Create a resource with v1.0 API endpoint
resource_v1 <- api_resource$new(
  client = client,
  endpoint = "v1.0"
)

# Create a resource with beta API endpoint
resource_beta <- api_resource$new(
  client = client,
  endpoint = "beta"
)

# Make requests - the endpoint is automatically prepended
response <- resource_v1$.fetch(
  path = "/me",
  req_method = "get"
)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.client}}{The cloned api_client instance with modified base_req}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-api_resource-new}{\code{api_resource$new()}}
\item \href{#method-api_resource-clone}{\code{api_resource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_resource-new"></a>}}
\if{latex}{\out{\hypertarget{method-api_resource-new}{}}}
\subsection{Method \code{new()}}{
Create a new API resource instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_resource$new(client, endpoint)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{An \code{api_client} object that provides the base HTTP client
functionality. This will be cloned to avoid modifying the original.}

\item{\code{endpoint}}{A character string specifying the API endpoint or path
segment to append (e.g., \code{"v1.0"}, \code{"beta"}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{api_resource} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_resource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-api_resource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_resource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
