% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_propensity_scores.r
\name{compute_propensity_scores}
\alias{compute_propensity_scores}
\title{Compute inverse propensity scores}
\usage{
compute_propensity_scores(label_distribution, a = 0.55, b = 1.5)
}
\arguments{
\item{label_distribution}{Expects a data.frame with columns \code{"label_id",
  "label_freq", "n_docs"}. \code{label_freq} corresponds to the number of
occurences a label has in the gold standard. \code{n_docs} corresponds to
the total number of documents in the gold standard.}

\item{a}{A numeric parameter for the propensity score calculation, defaults
to 0.55.}

\item{b}{A numeric parameter for the propensity score calculation, defaults
to 1.5.}
}
\value{
A data.frame with columns \code{"label_id", "label_weight"}.
}
\description{
Compute inverse propensity scores based on a label distribution. Propensity
scores for extreme multi-label learning are proposed in Jain, H., Prabhu, Y.,
& Varma, M. (2016). Extreme Multi-label Loss Functions for Recommendation,
Tagging, Ranking and Other Missing Label Applications. Proceedings of the
22nd ACM SIGKDD International Conference on Knowledge Discovery and Data
Mining, 13-17-Aug, 935–944. \doi{10.1145/2939672.2939756}.
}
\examples{

library(tidyverse)
library(casimir)

label_distribution <- dnb_label_distribution

compute_propensity_scores(label_distribution)

}
