% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casimir_package.R
\name{options}
\alias{options}
\title{casimir Options}
\description{
Internally used, package-specific options. All options will prioritize R options() values, and fall back to environment variables if undefined. If neither the option nor the environment variable is set, a default value is used.
}
\section{Checking Option Values}{

Option values specific to \code{casimir} can be
accessed by passing the package name to \code{env}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{options::opts(env = "casimir")

options::opt(x, default, env = "casimir")
}\if{html}{\out{</div>}}
}

\section{Options}{

\describe{
\item{ignore_inconsistencies}{\describe{
Warnings about data inconsistencies will be silenced.\item{default: }{\preformatted{FALSE}}
\item{option: }{casimir.ignore_inconsistencies}
\item{envvar: }{R_CASIMIR_IGNORE_INCONSISTENCIES (evaluated if possible, raw string otherwise)}
}}

\item{progress}{\describe{
Display progress bars for iterated computations (like bootstrap CI or
pr curves).\item{default: }{\preformatted{FALSE}}
\item{option: }{casimir.progress}
\item{envvar: }{R_CASIMIR_PROGRESS (evaluated if possible, raw string otherwise)}
}}

\item{verbose}{\describe{
Verbose reporting of computation steps for debugging.\item{default: }{\preformatted{FALSE}}
\item{option: }{casimir.verbose}
\item{envvar: }{R_CASIMIR_VERBOSE (evaluated if possible, raw string otherwise)}
}}

\item{check_group_names}{\describe{
Perform replacement of dots in grouping columns. Disable for faster
computation if you can make sure that all columns used for grouping
("doc_id", "label_id", "doc_groups", "label_groups") do not contain
dots.\item{default: }{\preformatted{TRUE}}
\item{option: }{casimir.check_group_names}
\item{envvar: }{R_CASIMIR_CHECK_GROUP_NAMES (evaluated if possible, raw string otherwise)}
}}

\item{drop_empty_groups}{\describe{
Should empty levels of factor variables be dropped in grouped set retrieval
computation?\item{default: }{\preformatted{TRUE}}
\item{option: }{casimir.drop_empty_groups}
\item{envvar: }{R_CASIMIR_DROP_EMPTY_GROUPS (evaluated if possible, raw string otherwise)}
}}

\item{replace_zero_division_with}{\describe{
In macro averaged results (doc-avg, subj-avg), it may occur that some
instances have no predictions or no gold standard. In these cases,
calculating precision and recall may lead to division by zero. CASIMiR
standardly removes these missing values from macro averages, leading to a
smaller support (count of instances that were averaged). Other
implementations of macro averaged precision and recall default to 0 in these
cases. This option allows to control the default. Set any value between 0
and 1.\item{default: }{\preformatted{NULL}}
\item{option: }{casimir.replace_zero_division_with}
\item{envvar: }{R_CASIMIR_REPLACE_ZERO_DIVISION_WITH (evaluated if possible, raw string otherwise)}
}}

}
}

\seealso{
options getOption Sys.setenv Sys.getenv
}
