% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cptgaisl-class.R
\name{plot.cptgaisl}
\alias{plot.cptgaisl}
\title{Plot Time Series with Detected Changepoints from a `cptgaisl` Object}
\usage{
\method{plot}{cptgaisl}(
  x,
  data,
  main = NULL,
  XTickLab = NULL,
  XTickPos = NULL,
  XAxisLab = "Time",
  YAxisLab = "Data",
  cex.lab = 1.3,
  cex.axis = 1.3,
  cex.main = 1.3,
  lwd = 2,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cptgaisl}, typically returned by an island model genetic algorithm based
changepoint detection procedure.}

\item{data}{A numeric vector representing the observed univariate time series.}

\item{main}{Optional main title for the plot.}

\item{XTickLab}{Optional vector (e.g., numeric or date) for custom x-axis labels.
Must be the same length as \code{data}.}

\item{XTickPos}{Optional vector specifying which elements of \code{XTickLab} to show as ticks.}

\item{XAxisLab}{Optional label for the x-axis. Default is \code{"Time"}.}

\item{YAxisLab}{Optional label for the y-axis. Default is \code{"Data"}.}

\item{cex.lab}{Text size for axis labels and margin text. Default is \code{1.3}.}

\item{cex.axis}{Text size for axis tick labels. Default is \code{1.3}.}

\item{cex.main}{Text size for the main title. Default is \code{1.3}.}

\item{lwd}{Line width for vertical and horizontal dashed lines. Default is \code{2}.}

\item{...}{Additional graphical parameters passed to \code{plot()}.}
}
\value{
This function is called for its side effects and returns \code{NULL} invisibly.
}
\description{
This function visualizes a univariate time series along with the changepoints
identified by a island model genetic algorithm, as represented by a `cptgaisl` object.
Vertical dashed lines mark changepoint locations, and segment means are shown as horizontal
dashed lines. The optimal fitness value and changepoint locations are
displayed as margin text.
}
\details{
If \code{XTickLab} is supplied and matches the length of \code{data}, it is used for
the x-axis; otherwise, the default sequence \code{1:length(data)} is used.

If the genetic algorithm was run with \code{option = "both"}, the function skips hyperparameters
in the chromosome when extracting changepoint positions.

The plot displays vertical dashed lines at changepoint locations and horizontal dashed
lines for the mean of each segment. Fitness and changepoint summaries are shown above the plot.
}
\seealso{
\code{\link[=summary,cptgaisl-method]{summary}}, \code{\link{print.summary.cptgaisl}}
}
