% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject_standardize.R
\name{get_samples}
\alias{get_samples}
\title{Generate a sample of values from a vector and collapse them.}
\usage{
get_samples(x, unique_only = FALSE, n_samples = 10, collapse = "\\n")
}
\arguments{
\item{x}{A vector of values.}

\item{unique_only}{A logical value indicating whether to return unique values only.}

\item{n_samples}{The number of samples to return.}

\item{collapse}{The separator to use for collapsing the values.}
}
\value{
A character string.
}
\description{
Generate a string summary of a vector by picking samples.
}
\examples{
get_samples(c(1, 2, 3, 4, 5))
get_samples(c(1, 2, 3, 4, 5), n_samples = 2)
get_samples(c(1, 2, 3, 3, 3), n_samples = 2, unique_only = TRUE)
get_samples(c(1, 2, 3, 4, 5), collapse = ", ")
}
