% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_weights.R
\name{lasso_weights}
\alias{lasso_weights}
\title{Compute the Weight Matrix for the Lasso Penalty}
\usage{
lasso_weights(S, unit = FALSE)
}
\arguments{
\item{S}{The sample covariance matrix of the data.}

\item{unit}{A logical indicating whether the weights should be all one or
based on the inverse of \code{S}.}
}
\value{
A weight matrix for the lasso penalty.
}
\description{
Compute the weight matrix for the lasso penalty in the clusterpath estimator
of the Gaussian graphical model (CGGM).
}
\examples{
# Generate data
set.seed(3)
Theta <- matrix(
  c(2, 1, 0, 0,
    1, 2, 0, 0,
    0, 0, 4, 1,
    0, 0, 1, 4),
  nrow = 4
)
X <- mvtnorm::rmvnorm(n = 100, sigma = solve(Theta))

# Estimate the covariance matrix
S <- cov(X)

# Compute the weight matrix for the lasso (sparsity) weights
W_lasso <- lasso_weights(S)
W_lasso
}
\references{
D.J.W. Touw, A. Alfons, P.J.F. Groenen and I. Wilms (2025)
\emph{Clusterpath Gaussian Graphical Modeling}. arXiv:2407.00644.
doi:10.48550/arXiv.2407.00644.
}
\seealso{
\code{\link{clusterpath_weights}()}, \code{\link{cggm}()},
\code{\link{cggm_refit}()}, \code{\link{cggm_cv}()}
}
\author{
Daniel J.W. Touw
}
