% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_df_not_null.R
\name{validate_arg_df_not_null}
\alias{validate_arg_df_not_null}
\title{Ensure that argument \code{df} is not \code{NULL}}
\usage{
validate_arg_df_not_null(df = NULL, function_name = NULL)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
dataframe
}
\description{
Internal function to validate the default value of the argument \code{df}.
}
\examples{
data(vi_smol)
df <- validate_arg_df_not_null(
  df = vi_smol
  )
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
