% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.crosses.r
\name{gl.sim.cross}
\alias{gl.sim.cross}
\alias{gl.sim.crosses}
\title{Generates random crosses between fathers and mothers}
\usage{
gl.sim.crosses(
  fathers,
  mothers,
  broodsize = 10,
  sexratio = 0.5,
  n = 1000,
  error.check = TRUE,
  compliance.check = TRUE,
  verbose = NULL
)
}
\arguments{
\item{fathers}{Genlight object of potential fathers [required].}

\item{mothers}{Genlight object of potential mothers simulated [required].}

\item{broodsize}{Number of offspring per mother [required].}

\item{sexratio}{Sex ratio of simulated offspring [default 0.5].}

\item{n}{Number of offspring to retain [default 1000 or mothers*broodsize whichever is the lesser]}

\item{error.check}{If TRUE, will perform error checks on the provided parameters [default TRUE]}

\item{compliance.check}{If TRUE, will perform a compliance check on the resultant
genlight object before returning it [default TRUE]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
A genlight object with n offspring of both sexes.
}
\description{
Generates random crosses between fathers (in one genlight object) and
mothers (in a second genlight object) then randomly selects a specified
number of offspring to retain.
}
\details{
This script is to be used in conjunction with gl.subsample.ind() applied
initially to a base genlight object containing initial male and female 
genotypes. The workflow is to

(a) Select the males from the base genlight object using gl.keep.pop() with 
pop.list="male" and the as.pop parameter set to sex.
(b) Select the females from the base genlight object using gl.keep.pop() with 
pop.list="female" and the as.pop parameter set to sex.
(c) Subsample a cohort of males for breeding and a cohort of females for breeding
using gl.subsample.ind() and the replace parameter as follows:

To enforce monogamy -- generate the fathers and mothers from the base genlight object
using gl.subsample.ind() with replace=FALSE.
To admit polygyny -- generate the fathers from the base genlight object using 
gl.subsample.ind() with replace=FALSE and the mothers from the base genlight
object using gl.subsample.ind() with replace=TRUE.
To admit polyandry -- generate the fathers from the base genlight object using 
gl.subsample.ind() with replace=TRUE and the mothers from the base genlight
object using gl.subsample.ind() with replace=FALSE.
To admit promiscuity -- generate the fathers and mothers from the base genlight object using
gl.subsample.ind() with replace=TRUE.

These are simple scenarios that leave the number of maternal mates per 
father (polygyny) and the number of paternal mates per mother (polyandry) 
to chance, depending on the random selection of males and females with 
replacement from the base genlight object.

(d) Cross the males with the females using gl.sim.crosses() retaining a
subset of offspring at random.

So the input for this function is a genlight object with a sample of male
individuals (fathers) selected from a larger set at random with or without 
replacement; a similar sample of female individuals in a second genlight 
object (mothers); specified broodsize; and desired offspring sex ratio.

Set check.error to FALSE if using this script in simulations
}
\author{
Custodian: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{simulation}
