% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_date}
\alias{what_date}
\title{What date is it?}
\usage{
what_date(
  when = NA,
  rev = FALSE,
  as_string = TRUE,
  sep = "-",
  month_form = "m",
  tz = ""
)
}
\arguments{
\item{when}{Date(s) (as a scalar or vector).
Default: \code{when = NA}. 
Using \code{as.Date(when)} to convert strings into dates, 
and \code{Sys.Date()}, if \code{when = NA}.}

\item{rev}{Boolean: Reverse date (to %d-%m-%Y)?
Default: \code{rev = FALSE}.}

\item{as_string}{Boolean: Return as character string? 
Default: \code{as_string = TRUE}. 
If \code{as_string = FALSE}, a "Date" object is returned.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = "-"}.}

\item{month_form}{Character: Month format. 
Default: \code{month_form = "m"} for numeric month (01-12). 
Use \code{month_form = "b"} for short month name 
and \code{month_form = "B"} for full month name (in current locale).}

\item{tz}{Time zone.
Default: \code{tz = ""} (i.e., current system time zone,  
see \code{Sys.timezone()}). 
Use \code{tz = "UTC"} for Coordinated Universal Time.}
}
\value{
A character string or object of class "Date".
}
\description{
\code{what_date} provides a satisficing version of 
\code{Sys.Date()} that is sufficient for most purposes.
}
\details{
By default, \code{what_date} returns either 
\code{Sys.Date()} or the dates provided by \code{when} 
as a character string (using current system settings and 
\code{sep} for formatting).  
If \code{as_string = FALSE}, a "Date" object is returned. 

The \code{tz} argument allows specifying time zones 
(see \code{Sys.timezone()} for current setting 
and \code{OlsonNames()} for options.) 

However, \code{tz} is merely used to represent the 
dates provided to the \code{when} argument. 
Thus, there currently is no active conversion 
of dates into other time zones 
(see the \code{today} function of \strong{lubridate} package).
}
\examples{
what_date()  
what_date(sep = "/")
what_date(rev = TRUE)
what_date(rev = TRUE, sep = ".")
what_date(rev = TRUE, sep = " ", month_form = "B")

# with "POSIXct" times:
what_date(when = Sys.time())

# with time vector (of "POSIXct" objects):
ts <- c("1969-07-13 13:53 CET", "2020-12-31 23:59:59")
what_date(ts)
what_date(ts, rev = TRUE, sep = ".")
what_date(ts, rev = TRUE, month_form = "b")

# return a "Date" object:
dt <- what_date(as_string = FALSE)
class(dt)

# with time zone: 
ts <- ISOdate(2020, 12, 24, c(0, 12))  # midnight and midday UTC
what_date(when = ts, tz = "Pacific/Honolulu", as_string = FALSE)

}
\seealso{
\code{what_wday()} function to obtain (week)days; 
\code{what_time()} function to obtain times; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
