% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HSD2.R
\name{HSD2}
\alias{HSD2}
\title{Compute Tukey Honest Significant Differences (two-factor)}
\usage{
HSD2(data, .group1, .group2, y, ...)
}
\arguments{
\item{data}{An \code{\link{easynem-class}} data.}

\item{.group1}{Grouping variables factor 1.}

\item{.group2}{Grouping variables factor 2.}

\item{y}{Dependent variable (numeric data).}

\item{...}{Other parameters for \code{\link[stats]{TukeyHSD}}.}
}
\value{
An \code{\link{compare2-class}} object.
}
\description{
The \code{HSD2()} is used to Compute Tukey Honest Significant Differences for
grouped data and create \code{\link{compare2-class}}. This function is only
applicable to two-factor analysis, see \code{\link{HSD}} for a single factor
version of the function.
}
\details{
To facilitate code interpretation, It is recommended to use this function in
conjunction with the \code{\link{calc_compare2}} function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_compare <- nem |> calc_compare2(.group1 = con_crop, .group2 = season, y = pH, method = HSD2)
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem(tab = easynem_example("nemtab1.csv"),
                tax = easynem_example("nemtax1.csv"),
                meta = easynem_example("nemmeta1.csv"))
nem_test <- nem |>
              calc_compare2(.group1 = con_crop, .group2 = season, y = pH, method = HSD2)
nem_test
}
\seealso{
Other functions related to differential analysis methods: \code{\link{TTest2}},
\code{\link{TTest}}, \code{\link{WilcoxTest2}}, \code{\link{WilcoxTest}},
\code{\link{KruskalTest2}}, \code{\link{KruskalTest}}, \code{\link{LSD2}}, \code{\link{LSD}},
\code{\link{HSD}}.
}
