% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_cfr.R
\name{add_cfr}
\alias{add_cfr}
\title{Add case fatality rate (CFR) statistics to a gtsummary table}
\usage{
add_cfr(gts_object, deaths_var)
}
\arguments{
\item{gts_object}{A gtsummary object created with functions such as
\code{gtsummary::tbl_summary()} or \code{gtsummary::tbl_cross()}.}

\item{deaths_var}{A logical variable name in the data indicating death
status (e.g. \code{TRUE} for death).}
}
\value{
A modified gtsummary object with additional columns showing
the number of deaths, number of cases, case fatality rate, and 95\%
confidence interval.
}
\description{
This function wraps \code{gtsummary::add_stat()} to calculate and display
\strong{case fatality rates} (deaths among cases) with 95\% confidence intervals,
using the \code{epitabulate::case_fatality_rate_df()} function internally.
}
