% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_epmfd.R
\name{scale_epmfd}
\alias{scale_epmfd}
\title{Scale polytomous item responses}
\usage{
scale_epmfd(
  object,
  method = c("auto", "mirt", "mokken"),
  a_thr = 0.5,
  H_thr = 0.3
)
}
\arguments{
\item{object}{An \code{epmfd_raw} object created by \code{\link[=load_epmfd]{load_epmfd()}}.}

\item{method}{Scaling method. One of:
\itemize{
\item \code{"mirt"}: fit a one-factor graded response model (GRM).
\item \code{"mokken"}: perform nonparametric Mokken scale analysis.
\item \code{"auto"} (default): choose based on sample size
(\code{n >= 500} → GRM, otherwise Mokken).
}}

\item{a_thr}{Numeric. Threshold for item discrimination parameter \code{a}
when using GRM (default = 0.5). Items with \code{a < a_thr} are
removed.}

\item{H_thr}{Numeric. Threshold for item scalability coefficient \code{H_i}
when using Mokken analysis (default = 0.3). Items with
\code{H_i < H_thr} are removed.}
}
\value{
An object of class \code{epmfd_scaled}, a list containing:
\itemize{
\item \code{raw}: the original \code{epmfd_raw} object
\item \code{method}: scaling method actually used (\code{"mirt"} or
\code{"mokken"})
\item \code{kept}: names of items retained
\item \code{removed}: names of items removed
\item \code{model}: fitted GRM model (for \code{"mirt"}), else \code{NULL}
\item \code{ai}: item parameter estimates (for \code{"mirt"})
\item \code{a_thr}: discrimination threshold used (for \code{"mirt"})
\item \code{model_fit}: results of \code{mirt::M2()} (if available)
\item \code{Hi}: vector of item scalability coefficients (for
\code{"mokken"})
\item \code{H_thr}: scalability threshold used (for \code{"mokken"})
\item \code{items}: the vector containing all items names.
}
}
\description{
\code{scale_epmfd()} fits either a parametric graded response model (GRM, via
\pkg{mirt}) or a nonparametric Mokken model (via \pkg{mokken}) to
polytomous item-response data and filters out weak items based on
user-specified thresholds.
}
\details{
The function converts ordered factors to numeric before analysis.
\itemize{
\item For GRM (\code{mirt}), items are filtered by their discrimination
parameter \code{a}. The overall model fit is attempted using
\code{mirt::M2()}; if this fails (e.g., due to insufficient df), a warning
is issued and \code{model_fit = NULL}.
\item For Mokken, item scalability coefficients \code{H_i} are computed and
compared to \code{H_thr}.
}
}
\examples{
library(epmfd)
data<-load_epmfd(sampledata)
scale_epmfd(data)

}
\seealso{
\code{\link[=load_epmfd]{load_epmfd()}}, \code{\link[=misfit_epmfd]{misfit_epmfd()}}, \code{\link[=plot.epmfd_scaled]{plot.epmfd_scaled()}}
}
