% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cols_with_void.R
\name{cols_with_void}
\alias{cols_with_void}
\title{cols_with_void(): Detect Columns Containing Void Values}
\usage{
cols_with_void(
  data,
  include_na = TRUE,
  include_null = TRUE,
  include_empty_str = TRUE,
  return_names = TRUE
)
}
\arguments{
\item{data}{A data.frame or tibble.}

\item{include_na}{Logical. Detect \code{NA} if TRUE. Default: TRUE.}

\item{include_null}{Logical. Detect \code{NULL} if TRUE. Default: TRUE.}

\item{include_empty_str}{Logical. Detect \code{""} if TRUE. Default: TRUE.}

\item{return_names}{Logical. If TRUE (default), return column names; else logical vector.}
}
\value{
A character vector (column names) or logical vector indicating void presence per column.
}
\description{
Scan a data.frame or tibble and identify columns that contain any "void" values.
Void values include \code{NA}, \code{NULL}, and \code{""}, which can be toggled via parameters.
}
\examples{
df <- data.frame(name = c("A", "", "C"), score = c(1, NA, 3), id = 1:3)
cols_with_void(df)
cols_with_void(df, return_names = FALSE)
cols_with_void(df, include_na = FALSE)
}
