% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_experts.R
\name{analyse_gnn_results}
\alias{analyse_gnn_results}
\title{Analyse and Visualize GNN Results}
\usage{
analyse_gnn_results(
  gnn_results,
  prepared_data,
  group_mappings,
  create_roc_plot = TRUE,
  create_calibration_plot = TRUE,
  analyse_gate_weights = TRUE,
  analyse_gate_entropy = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{gnn_results}{A list object from the \code{train_gnn()} function.}

\item{prepared_data}{A list object from the \code{prepare_data()} function.}

\item{group_mappings}{A named list that maps the numeric group codes back to their character labels for plotting (e.g., \code{list('0' = "Male", '1' = "Female")}).}

\item{create_roc_plot}{Boolean, if TRUE, generates and returns a ROC curve plot.}

\item{create_calibration_plot}{Boolean, if TRUE, generates and returns a calibration plot.}

\item{analyse_gate_weights}{Boolean, if TRUE, performs gate weight analysis (density plot and t-test).}

\item{analyse_gate_entropy}{Boolean, if TRUE, performs gate entropy analysis.}

\item{verbose}{Logical, whether to print progress messages (default FALSE).}
}
\value{
A list containing ggplot objects and analysis tables.
}
\description{
Generates plots and statistical tests for interpreting the GNN model results.
}
