% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{get_hilbert_sphere_distance}
\alias{get_hilbert_sphere_distance}
\title{Computes the geodesic distance between two SRVFs on the Hilbert sphere}
\usage{
get_hilbert_sphere_distance(q1fun, q2fun)
}
\arguments{
\item{q1fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the first SRVF at \eqn{s}.}

\item{q2fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the second SRVF at \eqn{s}.}
}
\value{
A numeric value storing the geodesic distance between the two SRVFs.
}
\description{
Computes the geodesic distance between two SRVFs on the Hilbert sphere
}
\examples{
q1 <- curve2srvf(beta[, , 1, 1])
q2 <- curve2srvf(beta[, , 1, 2])
q1p <- to_hilbert_sphere(q1)
q2p <- to_hilbert_sphere(q2)
get_hilbert_sphere_distance(q1p, q2p)
}
