% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_concepts.R
\name{search_concepts}
\alias{search_concepts}
\title{Search for concepts in the Finto Skosmos API by query term with additional parameters}
\usage{
search_concepts(
  query,
  lang = NULL,
  labellang = NULL,
  vocab = NULL,
  type = NULL,
  parent = NULL,
  group = NULL,
  maxhits = NULL,
  offset = NULL,
  fields = NULL,
  unique = NULL
)
}
\arguments{
\item{query}{The term to search for, e.g., "sibelius".}

\item{lang}{Language of labels to match, e.g., "en" or "fi". Optional.}

\item{labellang}{Language of labels to return, e.g., "en" or "fi". Optional.}

\item{vocab}{Vocabulary or vocabularies to limit search to, e.g., "yso". Optional.}

\item{type}{Limit search to concepts of the given type(s), e.g., "skos:Concept". Optional.}

\item{parent}{Limit search to concepts which have the given concept as a parent. Optional.}

\item{group}{Limit search to concepts in a specific group. Optional.}

\item{maxhits}{Maximum number of results to return (default is 191 as per the screenshot). Optional.}

\item{offset}{Offset to start in the result set, useful for paging. Optional.}

\item{fields}{Extra fields to include in the results (space-separated list). Optional.}

\item{unique}{Boolean flag to return each concept only once. Optional.}
}
\value{
A data frame containing search results with columns: \code{uri}, \code{type}, \code{prefLabel}, \code{altLabel}, \code{hiddenLabel}, \code{lang}, and \code{vocab}.
}
\description{
Search for concepts in the Finto Skosmos API by query term with additional parameters
}
\examples{
concepts <- search_concepts(query = "sibelius", lang = "fi")
print(concepts)
}
