#' @title Example mesh data
#' @docType data
#' @description This is an example data set used for `fmesher` package examples.
#'
#' @usage
#' fmexample
#'
#' @format The data is a list containing these elements:
#'  \describe{
#'    \item{`loc`:}{ A `matrix` of points.}
#'    \item{`loc_sf`:}{ An `sfc` version of `loc`.}
#'    \item{`boundary_fm`:}{ A `fm_segm_list` of two `fm_segm` objects used in
#'      the mesh construction.}
#'    \item{`boundary_sf`:}{ An `sfc` list version of `boundary`.}
#'    \item{`mesh`:}{ An [fm_mesh_2d()] object.}
#'  }
#' @source
#' Generated by `data-raw/fmexample.R`.
#' @seealso [fmexample_sp()]
#' @examples
#' if (require(ggplot2, quietly = TRUE)) {
#'   ggplot() +
#'     geom_sf(data = fm_as_sfc(fmexample$mesh)) +
#'     geom_sf(data = fmexample$boundary_sf[[1]], fill = "red", alpha = 0.5)
#' }
"fmexample"

#' Add sp data to fmexample
#'
#' Adds `loc_sp` and `boundary_sp` to [fmexample] for use
#' in `sp` related code examples and tests.
#' @returns Returns a copy of [fmexample] with `loc_sp` (`SpatialPoints`) and
#' `boundary_sp` (`SpatialPolygons`) added.
#' @export
#' @examples
#' if (fm_safe_sp()) {
#'   fmexample_sp()
#' }
fmexample_sp <- function() {
  if (!requireNamespace("sp", quietly = TRUE)) {
    stop("The `sp` package is required by `fmexample_sp()`.")
  }
  ex <- fmesher::fmexample
  ex$loc_sp <- sf::as_Spatial(ex$loc_sf)
  ex$boundary_sp <- lapply(ex$boundary_sf, sf::as_Spatial)
  ex
}
