% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat.R
\docType{data}
\name{compat}
\alias{compat}
\title{fmrireg compatibility interface}
\format{
An object of class \code{list} of length 6.
}
\usage{
compat
}
\value{
A list environment containing compatibility functions:
\itemize{
\item \code{plan_from_phi}: Create whitening plan from AR coefficients
\item \code{whiten_with_phi}: Apply whitening given AR coefficients
\item \code{update_plan}: Update existing plan with new residuals
\item \code{plan_info}: Extract information from a plan object
\item \code{whiteness_score}: Compute whiteness metric from residuals
\item \code{afni_restricted_plan}: Build AFNI-style restricted AR plan from
root parameters (advanced; internal helper exposed via compat)
}
}
\description{
Stable entry points to help upstream packages reuse fmriAR whitening without
rewriting existing pipelines.
}
\examples{
# Create compatibility interface
compat_funcs <- compat

# Example: Create whitening plan from AR coefficients
phi <- c(0.3, 0.1)  # AR(2) coefficients
plan <- compat_funcs$plan_from_phi(phi, exact_first = TRUE)

# Example: Compute whiteness score
resid <- matrix(rnorm(100 * 10), 100, 10)
score <- compat_funcs$whiteness_score(resid)

}
\keyword{internal}
