\name{g.tests_pair}
\alias{g.tests_pair}
\title{New Non-parametric Tests for Multivariate Paired Data and Pair Matching}
\description{This function provides three non-parametric two-sample tests for paired data and pair matching.}
\usage{
g.tests_pair(E, n, test.type = "all", perm = 0)
}
\arguments{
  \item{E}{An edge matrix representing a similarity graph on all observations with the number of edges in the similarity graph being the number of rows and 2 columns. Each row records the indices of the two ends of an edge in the similarity graph.}
  \item{n}{The number of pairs.}
  \item{test.type}{The default value is "all", which means all three tests, the orignial edge-count test, the scaled edge-count test, and the generalized edge-count test, are performed. Set this value to "original" or "o" to perform only the original edge-count test; set this value to "scaled" or "s" to perform only the scaled edge-count test; set this value to "generalized" or "g" to perform only the generalized edge-count test.}
  \item{perm}{The number of permutations performed to calculate the p-value of the test. The default value is 0, which means the permutation is not performed and only the approximate p-value based on asymptotic theory is provided. Doing permutation could be time consuming, so be cautious if you want to set this value to be larger than 10,000.}
}
\value{
  \item{test.statistic}{The value of the test statistic.}
  \item{pval.approx}{The approximated p-value based on asymptotic theory.}
  \item{pval.perm}{The permutation p-value when the argument `perm` is positive.}
}
\references{
    Zhang J., Chen H., and Zhou XH. A new non-parametric test for multivariate paired data from pair matching or paired designs.
}
\examples{
# The "example_pair" data contains the paired data 'data_pair'. 
# It is a n by 2p matrix with n being the number of pairs and p being the dimension of 
# observations. 
# For each row, the first p columns represent the observation from sample 1, and the 
# second p columns represent the paired observation from sample 2. 
# The data is generated from a paired design with mean shift. 
    data(example_pair)
    n = nrow(data_pair)
    p = ncol(data_pair)/2
    k = 5
    data1 = data_pair[,1:p]
    data2 = data_pair[,(p+1):(2*p)]
    case = rbind(data1,data2)
    dist1 = as.matrix(dist(case))
    library("ade4")
    E = mstree(as.dist(dist1),k)
    g.tests_pair(E,n)

# Get permutation p-value with 300 permutations.
    g.tests_pair(E, n, perm = 300)
}




