% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gginnards.R
\docType{package}
\name{gginnards-package}
\alias{gginnards}
\alias{gginnards-package}
\title{gginnards: Explore the Innards of 'ggplot2' Objects}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Extensions to 'ggplot2' providing low-level debug tools: statistics and geometries echoing their data argument. Layer manipulation: deletion, insertion, extraction and reordering of layers. Deletion of unused variables from the data object embedded in "ggplot" objects.
}
\details{
The new facilities for cleanly defining new stats and geoms added to
  package 'ggplot2' in version 2.0.0 gave origin to this package. I needed
  tools to help me learn how layers work and to debug the extensions to
  'ggplot2' that I was developing. I share them through this package in the
  hope that they will help other users of 'ggplot2' understand how this
  this very popular graphics package works internally. The vignettes provide
  examples of how to use these tools both for debugging and learning how
  ggplots are stored.

Extensions provided:
\itemize{
\item "Debug" stats and a "debug" geom that print to the console a summary
of their \code{data} input.
\item Functions for inspecting and manipulating the list of layers of a
ggplot object.
\item Functions for exploring and manipulating the data embedded in
ggplot objects, including dropping unused variables.
}
}
\examples{
# echo the 'data' and 'params' as received by 'draw_panel()'
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_panel()

# echo the 'data' and 'params' as received by 'draw_group()'
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug_group()

# echo the 'data' and 'params' as received by 'draw_panel()'
ggplot(mtcars, aes(cyl, mpg, colour = factor(cyl))) +
  stat_summary(fun.data = "mean_se") +
  stat_summary(fun.data = "mean_se", geom = "debug_panel")

# echo the 'data' received by 'compute_panel()'
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  stat_debug_panel()

# echo the 'data' received by 'compute_group()'
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  stat_debug_group()

}
\references{
Package 'tidyverse' web site at \url{https://tidyverse.org/}\cr
Package 'ggplot2' documentation at \url{https://ggplot2.tidyverse.org/}\cr
Package 'ggplot2' source code at \url{https://github.com/tidyverse/ggplot2}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/gginnards/}
  \item \url{https://github.com/aphalo/gginnards}
  \item Report bugs at \url{https://github.com/aphalo/gginnards/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

}
