% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/images.R
\name{capturePlot}
\alias{capturePlot}
\title{Capture a plot as a saved file}
\usage{
capturePlot(
  expr,
  filename = tempfile(fileext = ".png"),
  device = defaultPngDevice(),
  width = 400,
  height = 400,
  res = 72,
  ...
)
}
\arguments{
\item{expr}{A plotting expression that generates a plot (or yields an object
that generates a plot when printed, like a ggplot2). We evaluate this
expression after activating the graphics device (\code{device}).}

\item{filename}{The output filename. By default, a temp file with \code{.png}
extension will be used; you should provide a filename with a different
extension if you provide a non-PNG graphics device function.}

\item{device}{A graphics device function; by default, this will be either
\code{\link[grDevices:png]{grDevices::png()}}, \code{\link[ragg:agg_png]{ragg::agg_png()}}, or \code{\link[Cairo:Cairo]{Cairo::CairoPNG()}}, depending on
your system and configuration. See \code{\link[=defaultPngDevice]{defaultPngDevice()}}.}

\item{width, height, res, ...}{Additional arguments to the \code{device} function.}
}
\description{
Easily generates a .png file (or other graphics file) from a plotting
expression.
}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
# Default settings
res <- capturePlot(plot(cars))

# View result
browseURL(res)

# Clean up
unlink(res)

# Custom width/height
pngpath <- tempfile(fileext = ".png")
capturePlot(plot(pressure), pngpath, width = 800, height = 375)
browseURL(pngpath)
unlink(pngpath)

# Use a custom graphics device (e.g., SVG)
if (capabilities("cairo")) {
  svgpath <- capturePlot(
    plot(pressure),
    tempfile(fileext = ".svg"),
    grDevices::svg,
    width = 8, height = 3.75
  )
  browseURL(svgpath)
  unlink(svgpath)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=plotTag]{plotTag()}} saves plots as a self-contained \verb{<img>}
tag.
}
