% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_optimal}
\alias{cluster_optimal}
\title{Optimal community structure}
\usage{
cluster_optimal(graph, weights = NULL)
}
\arguments{
\item{graph}{The input graph. It may be undirected or directed.}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, \code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}
}
\value{
\code{cluster_optimal()} returns a \code{\link[=communities]{communities()}} object,
please see the \code{\link[=communities]{communities()}} manual page for details.
}
\description{
This function calculates the optimal community structure of a graph, by
maximizing the modularity measure over all possible partitions.
}
\details{
This function calculates the optimal community structure for a graph, in
terms of maximal modularity score.

The calculation is done by transforming the modularity maximization into an
integer programming problem, and then calling the GLPK library to solve
that. Please the reference below for details.

Note that modularity optimization is an NP-complete problem, and all known
algorithms for it have exponential time complexity. This means that you
probably don't want to run this function on larger graphs. Graphs with up to
fifty vertices should be fine, graphs with a couple of hundred vertices
might be possible.
}
\section{Examples}{

\preformatted{

## Zachary's karate club
g <- make_graph("Zachary")

## We put everything into a big 'try' block, in case
## igraph was compiled without GLPK support

## The calculation only takes a couple of seconds
oc <- cluster_optimal(g)

## Double check the result
print(modularity(oc))
print(modularity(g, membership(oc)))

## Compare to the greedy optimizer
fc <- cluster_fast_greedy(g)
print(modularity(fc))
}
}

\references{
Ulrik Brandes, Daniel Delling, Marco Gaertler, Robert Gorke,
Martin Hoefer, Zoran Nikoloski, Dorothea Wagner: On Modularity Clustering,
\emph{IEEE Transactions on Knowledge and Data Engineering} 20(2):172-188,
2008.
}
\seealso{
\code{\link[=communities]{communities()}} for the documentation of the result,
\code{\link[=modularity]{modularity()}}. See also \code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}} for a
fast greedy optimizer.

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()},
\code{\link{voronoi_cells}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{community}
\keyword{graphs}
