% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{edge_attr<-}
\alias{edge_attr<-}
\alias{edge.attributes<-}
\title{Set one or more edge attributes}
\usage{
edge_attr(graph, name, index = E(graph)) <- value
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the edge attribute to set. If missing,
then \code{value} must be a named list, and its entries are
set as edge attributes.}

\item{index}{An optional edge sequence to set the attributes
of a subset of edges.}

\item{value}{The new value of the attribute(s) for all
(or \code{index}) edges.}
}
\value{
The graph, with the edge attribute(s) added or set.
}
\description{
Set one or more edge attributes
}
\examples{
g <- make_ring(10)
edge_attr(g) <- list(
  name = LETTERS[1:10],
  color = rep("green", gsize(g))
)
edge_attr(g, "label") <- E(g)$name
g
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{set_vertex_attrs}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
