% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_public.R
\name{pubRepFilter}
\alias{pubRepFilter}
\alias{publicRepertoireFilter}
\title{Filter out clonotypes from public repertoires}
\usage{
pubRepFilter(.pr, .meta, .by, .min.samples = 1)
}
\arguments{
\item{.pr}{Public repertoires, an output from \link{pubRep}.}

\item{.meta}{Metadata file.}

\item{.by}{Named character vector. Names of the group to filter by.}

\item{.min.samples}{Integer. Filters out clonotypes with the number of samples below than this number.}
}
\value{
Data frame with filtered clonotypes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Filter our clonotypes with low incidence in a specific group.
}
\examples{
data(immdata)
immdata$data <- lapply(immdata$data, head, 2000)
pr <- pubRep(immdata$data, .verbose = FALSE)
pr1 <- pubRepFilter(pr, immdata$meta, .by = c(Status = "MS"))
head(pr1)
}
\concept{pubrep}
