% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_y_sequential}
\alias{process_y_sequential}
\title{Process Outcome Input for Keras}
\usage{
process_y_sequential(y, is_classification = NULL, class_levels = NULL)
}
\arguments{
\item{y}{A vector of outcomes.}

\item{is_classification}{Logical, optional. If \code{TRUE}, treats \code{y} as
classification. If \code{FALSE}, treats as regression. If \code{NULL} (default),
it's determined from \code{is.factor(y)}.}

\item{class_levels}{Character vector, optional. The factor levels for
classification outcomes. If \code{NULL} (default), determined from \code{levels(y)}.}
}
\value{
A list containing:
\itemize{
\item \code{y_proc}: The processed outcome data (matrix or one-hot encoded array).
\item \code{is_classification}: Logical, indicating if \code{y} was treated as classification.
\item \code{num_classes}: Integer, the number of classes for classification, or \code{NULL}.
\item \code{class_levels}: Character vector, the factor levels for classification, or \code{NULL}.
}
}
\description{
Preprocesses outcome data (\code{y}) into a format suitable for Keras models.
Handles both regression (numeric) and classification (factor) outcomes,
including one-hot encoding for classification.
}
\keyword{internal}
