# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test import_csv functionality
test_that("import_csv reads CSV files correctly", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")  # Get example CSV files
  )
  
  # Test basic functionality with data.table
  test_that("import_csv works with data.table package", {
    result <- import_csv(csv_files, package = "data.table")
    
    # Check return type
    expect_s3_class(result, "data.table")
    
    # Check rbind_label column exists when multiple files
    if (length(csv_files) > 1) {
      expect_true("_file" %in% names(result))
    }
    
    # Check data is not empty
    expect_true(nrow(result) > 0)
  })
  
  # Test with arrow package
  test_that("import_csv works with arrow package", {
    skip_if_not_installed("arrow")
    
    result <- import_csv(csv_files, package = "arrow")
    
    # Check return type (arrow converts to data.frame/data.table)
    expect_true(is.data.frame(result))
    
    # Check rbind_label column exists when multiple files
    if (length(csv_files) > 1) {
      expect_true("_file" %in% names(result))
    }
  })
  
  # Test rbind = FALSE
  test_that("import_csv returns list when rbind = FALSE", {
    result <- import_csv(csv_files, rbind = FALSE)
    
    # Check return type
    expect_type(result, "list")
    
    # Check list names (basename without extension by default)
    expected_names <- tools::file_path_sans_ext(basename(csv_files))
    expect_equal(names(result), expected_names)
    
    # Check each element is a data.table
    expect_true(all(sapply(result, data.table::is.data.table)))
  })
  
  # Test custom rbind_label
  test_that("import_csv handles custom rbind_label", {
    custom_label <- "source_file"
    result <- import_csv(csv_files, rbind_label = custom_label)
    
    if (length(csv_files) > 1) {
      expect_true(custom_label %in% names(result))
    }
  })
})

# Test error handling
test_that("import_csv handles errors appropriately", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")
  )
  
  # Test invalid file path
  expect_error(
    import_csv("nonexistent.csv"),
    "file must be a vector of existing file paths"
  )
  
  # Test invalid package parameter
  expect_error(
    import_csv(csv_files, package = "invalid"),
    "package must be one of 'data.table', 'arrow'"
  )
  
  # Test invalid full_path parameter
  expect_error(
    import_csv(csv_files, full_path = "invalid"),
    "full_path and keep_ext must be logical"
  )
  
  # Test invalid keep_ext parameter
  expect_error(
    import_csv(csv_files, keep_ext = 1),
    "full_path and keep_ext must be logical"
  )
})

# Test edge cases
test_that("import_csv handles edge cases", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")
  )
  
  # Test single file
  test_that("import_csv handles single file correctly", {
    single_result <- import_csv(csv_files[1])
    # No rbind_label column should be added for single file
    expect_false("_file" %in% names(single_result))
  })
  
  # Test with NULL rbind_label
  test_that("import_csv handles NULL rbind_label", {
    result <- import_csv(csv_files, rbind_label = NULL)
    expect_s3_class(result, "data.table")
    expect_false("_file" %in% names(result))
  })
})

# Test file labeling parameters
test_that("import_csv file labeling works correctly", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")
  )
  
  if (length(csv_files) > 1) {
    # Test default: basename without extension
    test_that("import_csv default file labels (basename, no ext)", {
      result <- import_csv(csv_files, full_path = FALSE, keep_ext = FALSE)
      expected <- tools::file_path_sans_ext(basename(csv_files))
      expect_equal(unique(result$`_file`), expected)
    })
    
    # Test: basename with extension
    test_that("import_csv file labels with extension", {
      result <- import_csv(csv_files, full_path = FALSE, keep_ext = TRUE)
      expected <- basename(csv_files)
      expect_equal(unique(result$`_file`), expected)
    })
    
    # Test: full path without extension
    test_that("import_csv file labels with full path", {
      result <- import_csv(csv_files, full_path = TRUE, keep_ext = FALSE)
      expected <- tools::file_path_sans_ext(csv_files)
      expect_equal(unique(result$`_file`), expected)
    })
    
    # Test: full path with extension
    test_that("import_csv file labels with full path and extension", {
      result <- import_csv(csv_files, full_path = TRUE, keep_ext = TRUE)
      expect_equal(unique(result$`_file`), csv_files)
    })
  }
  
  # Test rbind = FALSE with different labeling options
  test_that("import_csv list names respect labeling parameters", {
    # With keep_ext = TRUE
    result_with_ext <- import_csv(csv_files, rbind = FALSE, keep_ext = TRUE)
    expect_equal(names(result_with_ext), basename(csv_files))
    
    # With full_path = TRUE
    result_full <- import_csv(csv_files, rbind = FALSE, full_path = TRUE)
    expected_full <- tools::file_path_sans_ext(csv_files)
    expect_equal(names(result_full), expected_full)
  })
})

# Test additional parameters
test_that("import_csv handles additional parameters correctly", {
  # Setup test files
  csv_files <- mintyr_example(
    mintyr_examples(pattern = "\\.csv$")
  )
  
  # Test with additional fread/read_csv_arrow parameters
  test_that("import_csv passes additional parameters correctly", {
    # Test with data.table
    result_dt <- import_csv(csv_files, package = "data.table", header = TRUE, sep = ",")
    expect_s3_class(result_dt, "data.table")
    
    # Test with arrow
    skip_if_not_installed("arrow")
    result_arrow <- import_csv(csv_files, package = "arrow", col_names = TRUE)
    expect_true(is.data.frame(result_arrow))
  })
})
