% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cronbach_alpha_enum.R
\name{cronbach_alpha_enum}
\alias{cronbach_alpha_enum}
\title{Compute Exact Bounds of Cronbach's Alpha via Enumeration}
\usage{
cronbach_alpha_enum(scores_mat, score_max)
}
\arguments{
\item{scores_mat}{A matrix where rows represent individuals and columns represent test items.
It contains the performance of individuals on different test items, with NA for missing values.}

\item{score_max}{An integer specifying the largest possible score for any test item.}
}
\value{
A numeric vector of length 2, where the first element is the minimum Cronbach's alpha and the second element is the maximum Cronbach's alpha.
}
\description{
This function computes the minimum and maximum possible values of Cronbach's alpha
by enumerating all possible values for unknown entries in the score matrix.
}
\details{
This function works by enumerating all possible combinations of values for missing entries (represented by NA) in the \code{scores_mat}.
It systematically explores all combinations of missing values from \code{0} to \code{score_max} using the \code{expand.grid} function.
For each combination, it calculates Cronbach's alpha using the \code{compute_cronbach_alpha} function and keeps track of the minimum and maximum alpha values encountered.

The enumeration ensures that the function finds the exact minimum and maximum possible values of Cronbach's alpha given the possible missing score combinations.
However, due to the exhaustive nature of enumeration, this function may become computationally expensive for large datasets or a high number of missing values.
}
\seealso{
\code{\link{cronbach_alpha_rough}}
}
