% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedfact.R
\name{mixedfact}
\alias{mixedfact}
\title{Generate and Analyze Mixed-Level Blocked Factorial Designs}
\usage{
mixedfact(levels_vec, block_size, method = "auto", verbose = TRUE)
}
\arguments{
\item{levels_vec}{Integer vector of factor levels
(e.g., \code{c(2, 3, 4)} for a \eqn{2 \times 3 \times 4} design).}

\item{block_size}{Integer giving the number of runs per block.
Must divide the total number of treatment combinations.}

\item{method}{Character string specifying the generator method:
\itemize{
  \item \code{"auto"} (default): try GF, then collapsed, then heuristic.
  \item \code{"gf"}: finite-field based optimized generator.
  \item \code{"collapsed"}: random collapsed blocks.
  \item \code{"heuristic"}: heuristic ordering and blocking.
}}

\item{verbose}{Logical; if \code{TRUE}, prints progress, summaries, and
efficiency output.}
}
\value{
A list with components:
\describe{
  \item{code1}{Output from the generator, including \code{blocks},
    \code{confounding}, and (if applicable) \code{gf_info}.}
  \item{code2}{Output from the analyzer, including OFS and efficiency
    results.}
  \item{factor_levels}{The vector \code{levels_vec} supplied.}
  \item{block_size}{The block size used.}
  \item{blocks_numeric}{List of blocks with numeric factor values
    \code{F1}, \code{F2}, …}
  \item{blocks_labels}{List of blocks as character labels
    (e.g., \code{"012"}).}
}
}
\description{
Constructs blocked designs for mixed-level factorial experiments for a given
block size using finite-field based, collapsed, and heuristic methods. The
procedure creates the full treatment combination table, partitions runs into
blocks, and computes detailed confounding diagnostics for main effects and
two-factor interactions. The analyzer normalizes blocks into canonical labels,
checks balance and Orthogonal Factorial Structure (OFS), and computes
efficiencies of factorial effects. When OFS does not hold but the design has
equal treatment replications and equal block sizes, a general method based on
the C-matrix and custom contrast vectors is used to compute efficiencies. The
output includes GF-related metadata (when applicable), confounding summaries,
OFS diagnostics, and efficiency results.
}
\details{
Internally, the algorithm:
\itemize{
  \item Generates candidate block structures (GF-based, collapsed, or heuristic).
  \item Computes confounding summaries for main effects and two-factor interactions.
  \item Normalizes blocks and checks balance and OFS.
  \item Computes efficiency factors for main and interaction effects.
}
}
\examples{
\donttest{
  out <- mixedfact(c(2, 3, 4), block_size = 12)
  str(out$code1)
  str(out$code2)
}

}
\references{
K. R. Nair and C. R. Rao (1948).
\emph{Confounding in Asymmetrical Factorial Experiments.}
Journal of the Royal Statistical Society: Series B (Methodological),
\strong{10}(1), 109-131.

Gupta, S. and Mukerjee, R. (1989).
\emph{A Calculus for Factorial Arrangements.}
Lecture Notes in Statistics, Volume 59. Springer-Verlag.
}
