% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorBatchDesignPoints.R
\name{mlr_fselectors_design_points}
\alias{mlr_fselectors_design_points}
\alias{FSelectorBatchDesignPoints}
\title{Feature Selection with Design Points}
\description{
Feature selection using user-defined feature sets.
}
\details{
The feature sets are evaluated in order as given.

The feature selection terminates itself when all feature sets are evaluated.
It is not necessary to set a termination criterion.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("design_points")
}\if{html}{\out{</div>}}
}

\section{Parameters}{


\describe{
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of configurations to try in a batch.}
\item{\code{design}}{\link[data.table:data.table]{data.table::data.table}\cr
Design points to try in search, one per row.}
}

}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("pima")
learner = lrn("classif.rpart")

# create design
design = mlr3misc::rowwise_table(
  ~age, ~glucose, ~insulin, ~mass, ~pedigree, ~pregnant, ~pressure, ~triceps,
  TRUE, FALSE,    TRUE,     TRUE,  FALSE,     TRUE,       FALSE,    TRUE,
  TRUE, TRUE,     FALSE,    TRUE,  FALSE,     TRUE,       FALSE,    FALSE,
  TRUE, FALSE,    TRUE,     TRUE,  FALSE,     TRUE,       FALSE,    FALSE,
  TRUE, FALSE,    TRUE,     TRUE,  FALSE,     TRUE,       TRUE,     TRUE
)

# run feature selection on the Pima Indians diabetes data set
instance = fselect(
  fselector = fs("design_points", design = design),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce")
)

# best performing feature set
instance$result

# all evaluated feature sets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{FSelector}},
\code{\link{mlr_fselectors}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}}
}
\concept{FSelector}
\section{Super classes}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{\link[mlr3fselect:FSelectorBatch]{mlr3fselect::FSelectorBatch}} -> \code{\link[mlr3fselect:FSelectorBatchFromOptimizerBatch]{mlr3fselect::FSelectorBatchFromOptimizerBatch}} -> \code{FSelectorBatchDesignPoints}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorBatchDesignPoints-new}{\code{FSelectorBatchDesignPoints$new()}}
\item \href{#method-FSelectorBatchDesignPoints-clone}{\code{FSelectorBatchDesignPoints$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelectorBatchFromOptimizerBatch" data-id="optimize"><a href='../../mlr3fselect/html/FSelectorBatchFromOptimizerBatch.html#method-FSelectorBatchFromOptimizerBatch-optimize'><code>mlr3fselect::FSelectorBatchFromOptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorBatchDesignPoints-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorBatchDesignPoints-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorBatchDesignPoints$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorBatchDesignPoints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorBatchDesignPoints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorBatchDesignPoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
